﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudformation/CloudFormation_EXPORTS.h>
#include <aws/cloudformation/model/ResponseMetadata.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace CloudFormation {
namespace Model {
class ListImportsResult {
 public:
  AWS_CLOUDFORMATION_API ListImportsResult() = default;
  AWS_CLOUDFORMATION_API ListImportsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_CLOUDFORMATION_API ListImportsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>A list of stack names that are importing the specified exported output
   * value.</p>
   */
  inline const Aws::Vector<Aws::String>& GetImports() const { return m_imports; }
  template <typename ImportsT = Aws::Vector<Aws::String>>
  void SetImports(ImportsT&& value) {
    m_importsHasBeenSet = true;
    m_imports = std::forward<ImportsT>(value);
  }
  template <typename ImportsT = Aws::Vector<Aws::String>>
  ListImportsResult& WithImports(ImportsT&& value) {
    SetImports(std::forward<ImportsT>(value));
    return *this;
  }
  template <typename ImportsT = Aws::String>
  ListImportsResult& AddImports(ImportsT&& value) {
    m_importsHasBeenSet = true;
    m_imports.emplace_back(std::forward<ImportsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A string that identifies the next page of exports. If there is no additional
   * page, this value is null.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListImportsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  ListImportsResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_imports;
  bool m_importsHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  ResponseMetadata m_responseMetadata;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudFormation
}  // namespace Aws
