﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent-runtime/BedrockAgentRuntime_EXPORTS.h>
#include <aws/bedrock-agent-runtime/model/FlowExecutionErrorType.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace BedrockAgentRuntime {
namespace Model {

/**
 * <p>Contains information about an error that occurred during an flow
 * execution.</p>  <p>Flow executions is in preview release for Amazon
 * Bedrock and is subject to change.</p> <p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/FlowExecutionError">AWS
 * API Reference</a></p>
 */
class FlowExecutionError {
 public:
  AWS_BEDROCKAGENTRUNTIME_API FlowExecutionError() = default;
  AWS_BEDROCKAGENTRUNTIME_API FlowExecutionError(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENTRUNTIME_API FlowExecutionError& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENTRUNTIME_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the node in the flow where the error occurred (if
   * applicable).</p>
   */
  inline const Aws::String& GetNodeName() const { return m_nodeName; }
  inline bool NodeNameHasBeenSet() const { return m_nodeNameHasBeenSet; }
  template <typename NodeNameT = Aws::String>
  void SetNodeName(NodeNameT&& value) {
    m_nodeNameHasBeenSet = true;
    m_nodeName = std::forward<NodeNameT>(value);
  }
  template <typename NodeNameT = Aws::String>
  FlowExecutionError& WithNodeName(NodeNameT&& value) {
    SetNodeName(std::forward<NodeNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The error code for the type of error that occurred.</p>
   */
  inline FlowExecutionErrorType GetError() const { return m_error; }
  inline bool ErrorHasBeenSet() const { return m_errorHasBeenSet; }
  inline void SetError(FlowExecutionErrorType value) {
    m_errorHasBeenSet = true;
    m_error = value;
  }
  inline FlowExecutionError& WithError(FlowExecutionErrorType value) {
    SetError(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A descriptive message that provides details about the error.</p>
   */
  inline const Aws::String& GetMessage() const { return m_message; }
  inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }
  template <typename MessageT = Aws::String>
  void SetMessage(MessageT&& value) {
    m_messageHasBeenSet = true;
    m_message = std::forward<MessageT>(value);
  }
  template <typename MessageT = Aws::String>
  FlowExecutionError& WithMessage(MessageT&& value) {
    SetMessage(std::forward<MessageT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nodeName;
  bool m_nodeNameHasBeenSet = false;

  FlowExecutionErrorType m_error{FlowExecutionErrorType::NOT_SET};
  bool m_errorHasBeenSet = false;

  Aws::String m_message;
  bool m_messageHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockAgentRuntime
}  // namespace Aws
