# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DPMProtectedItemExtendedInfo(Model):
    """Additional information of DPM Protected item.

    :param protectable_object_load_path: Attribute to provide information on
     various DBs.
    :type protectable_object_load_path: dict[str, str]
    :param protected: To check if backup item is disk protected.
    :type protected: bool
    :param is_present_on_cloud: To check if backup item is cloud protected.
    :type is_present_on_cloud: bool
    :param last_backup_status: Last backup status information on backup item.
    :type last_backup_status: str
    :param last_refreshed_at: Last refresh time on backup item.
    :type last_refreshed_at: datetime
    :param oldest_recovery_point: Oldest cloud recovery point time.
    :type oldest_recovery_point: datetime
    :param recovery_point_count: cloud recovery point count.
    :type recovery_point_count: int
    :param on_premise_oldest_recovery_point: Oldest disk recovery point time.
    :type on_premise_oldest_recovery_point: datetime
    :param on_premise_latest_recovery_point: latest disk recovery point time.
    :type on_premise_latest_recovery_point: datetime
    :param on_premise_recovery_point_count: disk recovery point count.
    :type on_premise_recovery_point_count: int
    :param is_collocated: To check if backup item is collocated.
    :type is_collocated: bool
    :param protection_group_name: Protection group name of the backup item.
    :type protection_group_name: str
    :param disk_storage_used_in_bytes: Used Disk storage in bytes.
    :type disk_storage_used_in_bytes: str
    :param total_disk_storage_size_in_bytes: total Disk storage in bytes.
    :type total_disk_storage_size_in_bytes: str
    """

    _attribute_map = {
        'protectable_object_load_path': {'key': 'protectableObjectLoadPath', 'type': '{str}'},
        'protected': {'key': 'protected', 'type': 'bool'},
        'is_present_on_cloud': {'key': 'isPresentOnCloud', 'type': 'bool'},
        'last_backup_status': {'key': 'lastBackupStatus', 'type': 'str'},
        'last_refreshed_at': {'key': 'lastRefreshedAt', 'type': 'iso-8601'},
        'oldest_recovery_point': {'key': 'oldestRecoveryPoint', 'type': 'iso-8601'},
        'recovery_point_count': {'key': 'recoveryPointCount', 'type': 'int'},
        'on_premise_oldest_recovery_point': {'key': 'onPremiseOldestRecoveryPoint', 'type': 'iso-8601'},
        'on_premise_latest_recovery_point': {'key': 'onPremiseLatestRecoveryPoint', 'type': 'iso-8601'},
        'on_premise_recovery_point_count': {'key': 'onPremiseRecoveryPointCount', 'type': 'int'},
        'is_collocated': {'key': 'isCollocated', 'type': 'bool'},
        'protection_group_name': {'key': 'protectionGroupName', 'type': 'str'},
        'disk_storage_used_in_bytes': {'key': 'diskStorageUsedInBytes', 'type': 'str'},
        'total_disk_storage_size_in_bytes': {'key': 'totalDiskStorageSizeInBytes', 'type': 'str'},
    }

    def __init__(self, *, protectable_object_load_path=None, protected: bool=None, is_present_on_cloud: bool=None, last_backup_status: str=None, last_refreshed_at=None, oldest_recovery_point=None, recovery_point_count: int=None, on_premise_oldest_recovery_point=None, on_premise_latest_recovery_point=None, on_premise_recovery_point_count: int=None, is_collocated: bool=None, protection_group_name: str=None, disk_storage_used_in_bytes: str=None, total_disk_storage_size_in_bytes: str=None, **kwargs) -> None:
        super(DPMProtectedItemExtendedInfo, self).__init__(**kwargs)
        self.protectable_object_load_path = protectable_object_load_path
        self.protected = protected
        self.is_present_on_cloud = is_present_on_cloud
        self.last_backup_status = last_backup_status
        self.last_refreshed_at = last_refreshed_at
        self.oldest_recovery_point = oldest_recovery_point
        self.recovery_point_count = recovery_point_count
        self.on_premise_oldest_recovery_point = on_premise_oldest_recovery_point
        self.on_premise_latest_recovery_point = on_premise_latest_recovery_point
        self.on_premise_recovery_point_count = on_premise_recovery_point_count
        self.is_collocated = is_collocated
        self.protection_group_name = protection_group_name
        self.disk_storage_used_in_bytes = disk_storage_used_in_bytes
        self.total_disk_storage_size_in_bytes = total_disk_storage_size_in_bytes
