## Usage

```js
var Cache = require('{%= name %}');

// instantiate
var app = new Cache();

// set values
app.set('a', 'b');
app.set('c.d', 'e');

// get values
app.get('a');
//=> 'b'
app.get('c');
//=> {d: 'e'}

console.log(app.cache);
//=> {a: 'b'}
```

**Inherit**

```js
var util = require('util');
var Cache = require('{%= name %}');

function MyApp() {
  Cache.call(this);
}
util.inherits(MyApp, Cache);

var app = new MyApp();
app.set('a', 'b');
app.get('a');
//=> 'b'
```

**Namespace**

Define a custom property for storing values.

```js
var Cache = require('{%= name %}').namespace('data');
var app = new Cache();
app.set('a', 'b');
console.log(app.data);
//=> {a: 'b'}
```

## API

{%= apidocs("index.js") %}
