<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Square Root of 2π

> Square root of the mathematical constant [π][@stdlib/constants/float64/pi] times 2.

<section class="usage">

## Usage

```javascript
var SQRT_TWO_PI = require( '@stdlib/constants/float64/sqrt-two-pi' );
```

#### SQRT_TWO_PI

Square root of the mathematical constant [π][@stdlib/constants/float64/pi] times `2`.

```javascript
var bool = ( SQRT_TWO_PI === 2.5066282746310007 );
// returns true
```

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- TODO: better example -->

<!-- eslint no-undef: "error" -->

```javascript
var SQRT_TWO_PI = require( '@stdlib/constants/float64/sqrt-two-pi' );

console.log( SQRT_TWO_PI );
// => 2.5066282746310007
```

</section>

<!-- /.examples -->

<section class="links">

[@stdlib/constants/float64/pi]: https://github.com/stdlib-js/constants/tree/main/float64/pi

</section>

<!-- /.links -->
