/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import javax.xml.transform.ErrorListener;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.type.LengthFacet;
import net.sf.saxon.type.MaxLengthFacet;
import net.sf.saxon.type.MinLengthFacet;
import net.sf.saxon.type.PatternFacet;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValueRangeFacet;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.xpath.StandaloneContext;
import net.sf.saxon.xpath.XPathException;

public class Facet
implements Serializable {
    public static final String ENUMERATION = "enumeration";
    public static final String LENGTH = "length";
    public static final String PATTERN = "pattern";
    public static final String MAX_EXCLUSIVE = "maxExclusive";
    public static final String MAX_INCLUSIVE = "maxInclusive";
    public static final String MIN_EXCLUSIVE = "minExclusive";
    public static final String MIN_INCLUSIVE = "minInclusive";
    public static final String MAX_LENGTH = "maxLength";
    public static final String MIN_LENGTH = "minLength";
    public static final String WHITESPACE = "whiteSpace";
    public static final String TOTALDIGITS = "totalDigits";
    public static final String FRACTIONDIGITS = "fractionDigits";
    private String _name = null;
    private String _value = null;
    private Expression _test = null;

    protected Facet() {
    }

    public static Facet makeFacet(String name, String value) throws SchemaException {
        if (name.equals(PATTERN)) {
            PatternFacet lf = new PatternFacet();
            lf.setValue(value);
            return lf;
        }
        if (name.equals(LENGTH)) {
            LengthFacet lf = new LengthFacet();
            lf.setValue(value);
            return lf;
        }
        if (name.equals(MIN_LENGTH)) {
            MinLengthFacet lf = new MinLengthFacet();
            lf.setValue(value);
            return lf;
        }
        if (name.equals(MAX_LENGTH)) {
            MaxLengthFacet lf = new MaxLengthFacet();
            lf.setValue(value);
            return lf;
        }
        if (name.equals(MIN_INCLUSIVE)) {
            ValueRangeFacet vrf = new ValueRangeFacet(0);
            vrf.setValue(value);
            return vrf;
        }
        if (name.equals(MAX_INCLUSIVE)) {
            ValueRangeFacet vrf = new ValueRangeFacet(1);
            vrf.setValue(value);
            return vrf;
        }
        if (name.equals(MIN_EXCLUSIVE)) {
            ValueRangeFacet vrf = new ValueRangeFacet(2);
            vrf.setValue(value);
            return vrf;
        }
        if (name.equals(MAX_EXCLUSIVE)) {
            ValueRangeFacet vrf = new ValueRangeFacet(3);
            vrf.setValue(value);
            return vrf;
        }
        Facet f = new Facet();
        f._name = name;
        f._value = value;
        try {
            f._test = f.compileFacet();
        }
        catch (XPathException err) {
            throw new AssertionError((Object)("Invalid expression for facet: " + err.getMessage()));
        }
        return f;
    }

    private Expression compileFacet() throws XPathException, SchemaException {
        StandaloneContext env = new StandaloneContext();
        env.declareNamespace("xdt", "http://www.w3.org/2003/11/xpath-datatypes");
        String eval = Facet.escapeQuotes(this._value);
        String sval = "xdt:untypedAtomic('" + eval + "')";
        Expression exp = this._name.equals(ENUMERATION) ? ExpressionTool.make(". eq " + sval, env, 0, 0) : (this._name.equals(WHITESPACE) ? ExpressionTool.make("true()", env, 0, 0) : (this._name.equals(TOTALDIGITS) ? ExpressionTool.make("string-length(translate(., '+-.', '')) le " + sval, env, 0, 0) : (this._name.equals(FRACTIONDIGITS) ? ExpressionTool.make("if (contains(., '.')) then string-length(substring-after(., '.')) le " + sval + " else true()", env, 0, 0) : ExpressionTool.make("true()", env, 0, 0))));
        exp = exp.simplify();
        exp = exp.analyze(env);
        return exp;
    }

    private static String escapeQuotes(String value) {
        int apos = value.indexOf(39);
        if (apos < 0) {
            return value;
        }
        return value.substring(0, apos) + "''" + (apos == value.length() - 1 ? "" : Facet.escapeQuotes(value.substring(apos + 1)));
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public boolean isMultivalued() {
        return this._name.equals(ENUMERATION);
    }

    public long toLong() throws NumberFormatException {
        return Long.parseLong(this._value);
    }

    public short toShort() throws NumberFormatException {
        return Short.parseShort(this._value);
    }

    public float toFloat() throws NumberFormatException {
        if (this._value.equals("INF")) {
            return Float.POSITIVE_INFINITY;
        }
        if (this._value.equals("-INF")) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.valueOf(this._value).floatValue();
    }

    public double toDouble() throws NumberFormatException {
        return Double.valueOf(this._value);
    }

    public byte toByte() throws NumberFormatException {
        return Byte.parseByte(this._value);
    }

    public void checkFacetRestriction(SimpleType base) throws SchemaException {
        if (this._name.equals(ENUMERATION)) {
            try {
                base.validateContent(this._value, null);
            }
            catch (ValidationException err) {
                throw new SchemaException("The enumeration value \u00ab" + this._value + "\u00bb is not valid for the base type " + base.getDescription());
            }
        }
    }

    public boolean validate(ErrorListener errorListener) throws SchemaException {
        return true;
    }

    public boolean testAtomicValue(AtomicValue value) {
        try {
            XPathContext c = new XPathContext(value);
            return this._test.effectiveBooleanValue(c);
        }
        catch (XPathException err) {
            return false;
        }
    }
}

