/*--------------------------------------------------------------------
 * Symbols referenced in this file:
 * - ScanKeywords
 * - ScanKeywords_kw_string
 * - ScanKeywords_kw_offsets
 * - ScanKeywords_hash_func
 *--------------------------------------------------------------------
 */

/*-------------------------------------------------------------------------
 *
 * kwlist_d.h
 *    List of keywords represented as a ScanKeywordList.
 *
 * Portions Copyright (c) 1996-2023, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *  ******************************
 *  *** DO NOT EDIT THIS FILE! ***
 *  ******************************
 *
 *  It has been GENERATED by src/tools/gen_keywordlist.pl
 *
 *-------------------------------------------------------------------------
 */

#ifndef KWLIST_D_H
#define KWLIST_D_H

#include "common/kwlookup.h"

static const char ScanKeywords_kw_string[] =
	"abort\0"
	"absent\0"
	"absolute\0"
	"access\0"
	"action\0"
	"add\0"
	"admin\0"
	"after\0"
	"aggregate\0"
	"all\0"
	"also\0"
	"alter\0"
	"always\0"
	"analyse\0"
	"analyze\0"
	"and\0"
	"any\0"
	"array\0"
	"as\0"
	"asc\0"
	"asensitive\0"
	"assertion\0"
	"assignment\0"
	"asymmetric\0"
	"at\0"
	"atomic\0"
	"attach\0"
	"attribute\0"
	"authorization\0"
	"backward\0"
	"before\0"
	"begin\0"
	"between\0"
	"bigint\0"
	"binary\0"
	"bit\0"
	"boolean\0"
	"both\0"
	"breadth\0"
	"by\0"
	"cache\0"
	"call\0"
	"called\0"
	"cascade\0"
	"cascaded\0"
	"case\0"
	"cast\0"
	"catalog\0"
	"chain\0"
	"char\0"
	"character\0"
	"characteristics\0"
	"check\0"
	"checkpoint\0"
	"class\0"
	"close\0"
	"cluster\0"
	"coalesce\0"
	"collate\0"
	"collation\0"
	"column\0"
	"columns\0"
	"comment\0"
	"comments\0"
	"commit\0"
	"committed\0"
	"compression\0"
	"concurrently\0"
	"configuration\0"
	"conflict\0"
	"connection\0"
	"constraint\0"
	"constraints\0"
	"content\0"
	"continue\0"
	"conversion\0"
	"copy\0"
	"cost\0"
	"create\0"
	"cross\0"
	"csv\0"
	"cube\0"
	"current\0"
	"current_catalog\0"
	"current_date\0"
	"current_role\0"
	"current_schema\0"
	"current_time\0"
	"current_timestamp\0"
	"current_user\0"
	"cursor\0"
	"cycle\0"
	"data\0"
	"database\0"
	"day\0"
	"deallocate\0"
	"dec\0"
	"decimal\0"
	"declare\0"
	"default\0"
	"defaults\0"
	"deferrable\0"
	"deferred\0"
	"definer\0"
	"delete\0"
	"delimiter\0"
	"delimiters\0"
	"depends\0"
	"depth\0"
	"desc\0"
	"detach\0"
	"dictionary\0"
	"disable\0"
	"discard\0"
	"distinct\0"
	"do\0"
	"document\0"
	"domain\0"
	"double\0"
	"drop\0"
	"each\0"
	"else\0"
	"enable\0"
	"encoding\0"
	"encrypted\0"
	"end\0"
	"enum\0"
	"escape\0"
	"event\0"
	"except\0"
	"exclude\0"
	"excluding\0"
	"exclusive\0"
	"execute\0"
	"exists\0"
	"explain\0"
	"expression\0"
	"extension\0"
	"external\0"
	"extract\0"
	"false\0"
	"family\0"
	"fetch\0"
	"filter\0"
	"finalize\0"
	"first\0"
	"float\0"
	"following\0"
	"for\0"
	"force\0"
	"foreign\0"
	"format\0"
	"forward\0"
	"freeze\0"
	"from\0"
	"full\0"
	"function\0"
	"functions\0"
	"generated\0"
	"global\0"
	"grant\0"
	"granted\0"
	"greatest\0"
	"group\0"
	"grouping\0"
	"groups\0"
	"handler\0"
	"having\0"
	"header\0"
	"hold\0"
	"hour\0"
	"identity\0"
	"if\0"
	"ilike\0"
	"immediate\0"
	"immutable\0"
	"implicit\0"
	"import\0"
	"in\0"
	"include\0"
	"including\0"
	"increment\0"
	"indent\0"
	"index\0"
	"indexes\0"
	"inherit\0"
	"inherits\0"
	"initially\0"
	"inline\0"
	"inner\0"
	"inout\0"
	"input\0"
	"insensitive\0"
	"insert\0"
	"instead\0"
	"int\0"
	"integer\0"
	"intersect\0"
	"interval\0"
	"into\0"
	"invoker\0"
	"is\0"
	"isnull\0"
	"isolation\0"
	"join\0"
	"json\0"
	"json_array\0"
	"json_arrayagg\0"
	"json_object\0"
	"json_objectagg\0"
	"key\0"
	"keys\0"
	"label\0"
	"language\0"
	"large\0"
	"last\0"
	"lateral\0"
	"leading\0"
	"leakproof\0"
	"least\0"
	"left\0"
	"level\0"
	"like\0"
	"limit\0"
	"listen\0"
	"load\0"
	"local\0"
	"localtime\0"
	"localtimestamp\0"
	"location\0"
	"lock\0"
	"locked\0"
	"logged\0"
	"mapping\0"
	"match\0"
	"matched\0"
	"materialized\0"
	"maxvalue\0"
	"merge\0"
	"method\0"
	"minute\0"
	"minvalue\0"
	"mode\0"
	"month\0"
	"move\0"
	"name\0"
	"names\0"
	"national\0"
	"natural\0"
	"nchar\0"
	"new\0"
	"next\0"
	"nfc\0"
	"nfd\0"
	"nfkc\0"
	"nfkd\0"
	"no\0"
	"none\0"
	"normalize\0"
	"normalized\0"
	"not\0"
	"nothing\0"
	"notify\0"
	"notnull\0"
	"nowait\0"
	"null\0"
	"nullif\0"
	"nulls\0"
	"numeric\0"
	"object\0"
	"of\0"
	"off\0"
	"offset\0"
	"oids\0"
	"old\0"
	"on\0"
	"only\0"
	"operator\0"
	"option\0"
	"options\0"
	"or\0"
	"order\0"
	"ordinality\0"
	"others\0"
	"out\0"
	"outer\0"
	"over\0"
	"overlaps\0"
	"overlay\0"
	"overriding\0"
	"owned\0"
	"owner\0"
	"parallel\0"
	"parameter\0"
	"parser\0"
	"partial\0"
	"partition\0"
	"passing\0"
	"password\0"
	"placing\0"
	"plans\0"
	"policy\0"
	"position\0"
	"preceding\0"
	"precision\0"
	"prepare\0"
	"prepared\0"
	"preserve\0"
	"primary\0"
	"prior\0"
	"privileges\0"
	"procedural\0"
	"procedure\0"
	"procedures\0"
	"program\0"
	"publication\0"
	"quote\0"
	"range\0"
	"read\0"
	"real\0"
	"reassign\0"
	"recheck\0"
	"recursive\0"
	"ref\0"
	"references\0"
	"referencing\0"
	"refresh\0"
	"reindex\0"
	"relative\0"
	"release\0"
	"rename\0"
	"repeatable\0"
	"replace\0"
	"replica\0"
	"reset\0"
	"restart\0"
	"restrict\0"
	"return\0"
	"returning\0"
	"returns\0"
	"revoke\0"
	"right\0"
	"role\0"
	"rollback\0"
	"rollup\0"
	"routine\0"
	"routines\0"
	"row\0"
	"rows\0"
	"rule\0"
	"savepoint\0"
	"scalar\0"
	"schema\0"
	"schemas\0"
	"scroll\0"
	"search\0"
	"second\0"
	"security\0"
	"select\0"
	"sequence\0"
	"sequences\0"
	"serializable\0"
	"server\0"
	"session\0"
	"session_user\0"
	"set\0"
	"setof\0"
	"sets\0"
	"share\0"
	"show\0"
	"similar\0"
	"simple\0"
	"skip\0"
	"smallint\0"
	"snapshot\0"
	"some\0"
	"sql\0"
	"stable\0"
	"standalone\0"
	"start\0"
	"statement\0"
	"statistics\0"
	"stdin\0"
	"stdout\0"
	"storage\0"
	"stored\0"
	"strict\0"
	"strip\0"
	"subscription\0"
	"substring\0"
	"support\0"
	"symmetric\0"
	"sysid\0"
	"system\0"
	"system_user\0"
	"table\0"
	"tables\0"
	"tablesample\0"
	"tablespace\0"
	"temp\0"
	"template\0"
	"temporary\0"
	"text\0"
	"then\0"
	"ties\0"
	"time\0"
	"timestamp\0"
	"to\0"
	"trailing\0"
	"transaction\0"
	"transform\0"
	"treat\0"
	"trigger\0"
	"trim\0"
	"true\0"
	"truncate\0"
	"trusted\0"
	"type\0"
	"types\0"
	"uescape\0"
	"unbounded\0"
	"uncommitted\0"
	"unencrypted\0"
	"union\0"
	"unique\0"
	"unknown\0"
	"unlisten\0"
	"unlogged\0"
	"until\0"
	"update\0"
	"user\0"
	"using\0"
	"vacuum\0"
	"valid\0"
	"validate\0"
	"validator\0"
	"value\0"
	"values\0"
	"varchar\0"
	"variadic\0"
	"varying\0"
	"verbose\0"
	"version\0"
	"view\0"
	"views\0"
	"volatile\0"
	"when\0"
	"where\0"
	"whitespace\0"
	"window\0"
	"with\0"
	"within\0"
	"without\0"
	"work\0"
	"wrapper\0"
	"write\0"
	"xml\0"
	"xmlattributes\0"
	"xmlconcat\0"
	"xmlelement\0"
	"xmlexists\0"
	"xmlforest\0"
	"xmlnamespaces\0"
	"xmlparse\0"
	"xmlpi\0"
	"xmlroot\0"
	"xmlserialize\0"
	"xmltable\0"
	"year\0"
	"yes\0"
	"zone";

static const uint16 ScanKeywords_kw_offsets[] = {
	0,
	6,
	13,
	22,
	29,
	36,
	40,
	46,
	52,
	62,
	66,
	71,
	77,
	84,
	92,
	100,
	104,
	108,
	114,
	117,
	121,
	132,
	142,
	153,
	164,
	167,
	174,
	181,
	191,
	205,
	214,
	221,
	227,
	235,
	242,
	249,
	253,
	261,
	266,
	274,
	277,
	283,
	288,
	295,
	303,
	312,
	317,
	322,
	330,
	336,
	341,
	351,
	367,
	373,
	384,
	390,
	396,
	404,
	413,
	421,
	431,
	438,
	446,
	454,
	463,
	470,
	480,
	492,
	505,
	519,
	528,
	539,
	550,
	562,
	570,
	579,
	590,
	595,
	600,
	607,
	613,
	617,
	622,
	630,
	646,
	659,
	672,
	687,
	700,
	718,
	731,
	738,
	744,
	749,
	758,
	762,
	773,
	777,
	785,
	793,
	801,
	810,
	821,
	830,
	838,
	845,
	855,
	866,
	874,
	880,
	885,
	892,
	903,
	911,
	919,
	928,
	931,
	940,
	947,
	954,
	959,
	964,
	969,
	976,
	985,
	995,
	999,
	1004,
	1011,
	1017,
	1024,
	1032,
	1042,
	1052,
	1060,
	1067,
	1075,
	1086,
	1096,
	1105,
	1113,
	1119,
	1126,
	1132,
	1139,
	1148,
	1154,
	1160,
	1170,
	1174,
	1180,
	1188,
	1195,
	1203,
	1210,
	1215,
	1220,
	1229,
	1239,
	1249,
	1256,
	1262,
	1270,
	1279,
	1285,
	1294,
	1301,
	1309,
	1316,
	1323,
	1328,
	1333,
	1342,
	1345,
	1351,
	1361,
	1371,
	1380,
	1387,
	1390,
	1398,
	1408,
	1418,
	1425,
	1431,
	1439,
	1447,
	1456,
	1466,
	1473,
	1479,
	1485,
	1491,
	1503,
	1510,
	1518,
	1522,
	1530,
	1540,
	1549,
	1554,
	1562,
	1565,
	1572,
	1582,
	1587,
	1592,
	1603,
	1617,
	1629,
	1644,
	1648,
	1653,
	1659,
	1668,
	1674,
	1679,
	1687,
	1695,
	1705,
	1711,
	1716,
	1722,
	1727,
	1733,
	1740,
	1745,
	1751,
	1761,
	1776,
	1785,
	1790,
	1797,
	1804,
	1812,
	1818,
	1826,
	1839,
	1848,
	1854,
	1861,
	1868,
	1877,
	1882,
	1888,
	1893,
	1898,
	1904,
	1913,
	1921,
	1927,
	1931,
	1936,
	1940,
	1944,
	1949,
	1954,
	1957,
	1962,
	1972,
	1983,
	1987,
	1995,
	2002,
	2010,
	2017,
	2022,
	2029,
	2035,
	2043,
	2050,
	2053,
	2057,
	2064,
	2069,
	2073,
	2076,
	2081,
	2090,
	2097,
	2105,
	2108,
	2114,
	2125,
	2132,
	2136,
	2142,
	2147,
	2156,
	2164,
	2175,
	2181,
	2187,
	2196,
	2206,
	2213,
	2221,
	2231,
	2239,
	2248,
	2256,
	2262,
	2269,
	2278,
	2288,
	2298,
	2306,
	2315,
	2324,
	2332,
	2338,
	2349,
	2360,
	2370,
	2381,
	2389,
	2401,
	2407,
	2413,
	2418,
	2423,
	2432,
	2440,
	2450,
	2454,
	2465,
	2477,
	2485,
	2493,
	2502,
	2510,
	2517,
	2528,
	2536,
	2544,
	2550,
	2558,
	2567,
	2574,
	2584,
	2592,
	2599,
	2605,
	2610,
	2619,
	2626,
	2634,
	2643,
	2647,
	2652,
	2657,
	2667,
	2674,
	2681,
	2689,
	2696,
	2703,
	2710,
	2719,
	2726,
	2735,
	2745,
	2758,
	2765,
	2773,
	2786,
	2790,
	2796,
	2801,
	2807,
	2812,
	2820,
	2827,
	2832,
	2841,
	2850,
	2855,
	2859,
	2866,
	2877,
	2883,
	2893,
	2904,
	2910,
	2917,
	2925,
	2932,
	2939,
	2945,
	2958,
	2968,
	2976,
	2986,
	2992,
	2999,
	3011,
	3017,
	3024,
	3036,
	3047,
	3052,
	3061,
	3071,
	3076,
	3081,
	3086,
	3091,
	3101,
	3104,
	3113,
	3125,
	3135,
	3141,
	3149,
	3154,
	3159,
	3168,
	3176,
	3181,
	3187,
	3195,
	3205,
	3217,
	3229,
	3235,
	3242,
	3250,
	3259,
	3268,
	3274,
	3281,
	3286,
	3292,
	3299,
	3305,
	3314,
	3324,
	3330,
	3337,
	3345,
	3354,
	3362,
	3370,
	3378,
	3383,
	3389,
	3398,
	3403,
	3409,
	3420,
	3427,
	3432,
	3439,
	3447,
	3452,
	3460,
	3466,
	3470,
	3484,
	3494,
	3505,
	3515,
	3525,
	3539,
	3548,
	3554,
	3562,
	3575,
	3584,
	3589,
	3593,
};

#define SCANKEYWORDS_NUM_KEYWORDS 471

static int
ScanKeywords_hash_func(const void *key, size_t keylen)
{
	static const int16 h[943] = {
		543,   -186,  201,   0,     32767, 32767, 32767, 32767,
		221,   -207,  32767, 0,     135,   283,   32767, 454,
		14,    79,    32767, 32767, 77,    32767, 102,   160,
		0,     32767, 151,   32767, 30,    392,   -322,  452,
		32767, 0,     32767, 0,     0,     32767, 32767, 32767,
		234,   32767, 0,     32767, 0,     631,   32767, 368,
		80,    0,     0,     -115,  32767, 285,   32767, 423,
		0,     32767, 155,   229,   32767, 126,   291,   165,
		-22,   400,   327,   32767, 32767, 32767, 32767, -399,
		0,     406,   32767, 210,   1102,  -203,  32767, 32767,
		32767, -944,  0,     -188,  32767, 32767, 0,     347,
		32767, 0,     559,   316,   133,   32767, 202,   32767,
		305,   0,     32767, -94,   32767, 0,     32767, -222,
		32767, 138,   32767, -52,   32767, 32767, 279,   69,
		-136,  0,     32767, 32767, 189,   32767, 32767, 88,
		0,     32767, 32767, 274,   32767, 514,   769,   248,
		32767, 32767, 32767, 32767, 32767, 32767, 0,     81,
		8,     -29,   32767, 32767, 32767, -174,  258,   0,
		465,   211,   32767, 0,     -229,  32767, -191,  32767,
		1263,  48,    32767, 343,   0,     58,    0,     32767,
		32767, 855,   0,     415,   0,     -217,  32767, 1195,
		32767, 32767, 166,   32767, 42,    262,   -736,  0,
		32767, 32767, 418,   178,   122,   32767, 46,    32767,
		32767, 32767, 229,   443,   32767, 32767, 250,   32767,
		-300,  0,     32767, 1153,  32767, 108,   32767, -462,
		266,   32767, 478,   -220,  235,   32767, 32767, -127,
		32767, 32767, 32767, 427,   -231,  156,   32767, 0,
		0,     148,   -218,  142,   73,    420,   32767, 32767,
		523,   32767, -36,   32767, 32767, 467,   844,   -415,
		32767, 32767, -148,  179,   361,   32767, 151,   0,
		0,     32767, 145,   32767, 248,   110,   29,    125,
		282,   32767, -36,   43,    32767, 1125,  32767, 530,
		251,   519,   191,   0,     32767, -34,   -502,  313,
		462,   845,   32767, 32767, -255,  412,   32767, 78,
		0,     32767, 444,   161,   0,     32767, 308,   32767,
		-273,  400,   32767, 296,   32767, 32767, 72,    32767,
		32767, 34,    32767, 364,   151,   -63,   4,     229,
		0,     -276,  32767, 32767, 32767, 32767, -406,  32767,
		203,   32767, 140,   187,   160,   32767, 286,   0,
		32767, 32767, -88,   0,     100,   -361,  32767, 9,
		0,     -456,  32767, -37,   -404,  32767, -969,  32767,
		371,   95,    0,     703,   -31,   263,   373,   -745,
		507,   14,    32767, -159,  0,     32767, 47,    299,
		-126,  0,     32767, 83,    32767, 32767, 420,   236,
		32767, 32767, 0,     310,   89,    233,   32767, 93,
		32767, 0,     816,   60,    301,   211,   193,   0,
		452,   -107,  -403,  -242,  353,   18,    32767, 32767,
		32767, 243,   104,   32767, 32767, 32767, -305,  32767,
		-1048, 54,    0,     383,   32767, 32767, 32767, 226,
		319,   0,     32767, 32767, 32767, -130,  537,   32767,
		0,     -206,  240,   696,   121,   32767, 180,   164,
		32767, 390,   185,   32767, 220,   545,   29,    32767,
		0,     32767, 32767, 1120,  -163,  32767, 32767, 32767,
		-368,  136,   445,   171,   233,   32767, 73,    32767,
		92,    32767, 0,     32767, 0,     208,   354,   32767,
		54,    32767, 32767, -246,  -93,   389,   32767, 32767,
		32767, 32767, 50,    32767, 32767, 308,   32767, -278,
		0,     32767, 32767, -1172, 32767, 8,     32767, 0,
		32767, 341,   304,   242,   -174,  -92,   76,    419,
		32767, 87,    32767, -262,  32767, 32767, 32767, 109,
		200,   0,     32767, 0,     85,    530,   32767, -316,
		32767, 0,     -286,  32767, 193,   268,   32767, 32767,
		278,   32767, 32767, 155,   445,   95,    -310,  32767,
		207,   -56,   32767, 32767, 0,     -127,  232,   -283,
		103,   32767, 1,     0,     32767, 32767, -485,  350,
		79,    -56,   -354,  32767, 121,   24,    81,    20,
		325,   40,    248,   32767, 32767, 32767, 358,   32767,
		-56,   32767, 0,     174,   -28,   -301,  -92,   32767,
		114,   295,   32767, 363,   -355,  32767, 290,   0,
		32767, 32767, 32767, 122,   55,    -142,  32767, 50,
		32767, 32767, 152,   571,   1397,  0,     472,   -448,
		185,   140,   228,   435,   0,     32767, 32767, 414,
		32767, 379,   92,    185,   23,    299,   32767, 32767,
		0,     32767, 32767, 32767, 306,   439,   -198,  219,
		340,   32767, 416,   0,     -123,  377,   32767, 32767,
		0,     32767, 670,   -670,  339,   32767, 32767, 32767,
		0,     -256,  70,    514,   331,   0,     302,   469,
		0,     370,   32767, 32767, 42,    255,   212,   0,
		322,   277,   32767, -163,  32767, 216,   32767, 32767,
		0,     32767, 190,   32767, 32767, 0,     32767, 0,
		-409,  1366,  32767, 32767, 32767, 193,   32767, 325,
		32767, 0,     142,   466,   32767, 32767, 32767, 113,
		32767, 32767, 62,    0,     -62,   113,   -90,   34,
		-256,  32767, 32767, -936,  32767, 32767, 32767, 0,
		-64,   0,     -34,   451,   290,   108,   32767, 276,
		842,   0,     556,   -153,  32767, 412,   -168,  32767,
		32767, 1331,  407,   234,   -60,   115,   457,   -73,
		502,   772,   32767, 33,    404,   -925,  32767, 32767,
		421,   -123,  32767, 32767, 32767, 0,     0,     32767,
		32767, 32767, 429,   0,     3,     769,   -81,   306,
		64,    32767, 192,   96,    0,     63,    44,    32767,
		32767, 32767, 32767, 0,     284,   32767, 575,   32767,
		32767, 12,    32767, 516,   116,   32767, 32767, 150,
		442,   134,   32767, 198,   -45,   249,   40,    373,
		32767, 0,     32767, 32767, 0,     0,     352,   32767,
		117,   32767, 426,   0,     0,     32767, 32767, 32767,
		32767, -92,   32767, -442,  32767, 269,   32767, 32767,
		32767, 429,   32767, 0,     32767, 0,     143,   32767,
		508,   -66,   32767, 280,   32767, 39,    162,   32767,
		32767, 0,     32767, 31,    32767, 32767, 32767, 0,
		32767, 257,   -90,   -249,  224,   272,   32767, 32767,
		313,   -467,  214,   0,     -85,   32767, 48,    0,
		32767, -336,  202,   0,     447,   90,    264,   32767,
		32767, 0,     101,   32767, 32767, 32767, 0,     32767,
		32767, 227,   -1093, 32767, 0,     32767, 27,    174,
		32767, 7,     32767, -621,  146,   32767, 32767, 32767,
		854,   0,     32767, 161,   0,     137,   32767, 32767,
		32767, 32767, 0,     391,   219,   276,   32767, 168,
		32767, 32767, 0,     32767, 32767, 32767, 1,     -4,
		32767, 0,     293,   0,     374,   256,   0,     0,
		32767, 355,   212,   404,   0,     186,   32767, 0,
		359,   32767, 32767, 172,   32767, 32767, -131,  0,
		402,   0,     56,    32767, 462,   389,   82,    0,
		32767, 0,     32767, 0,     32767, 32767, 32767, 32767,
		106,   425,   -160,  31,    32767, 55,    0,     0,
		32767, 32767, 430,   1224,  179,   -179,  0,     397,
		32767, 0,     0,     0,     -60,   47,    32767, 396,
		32767, 326,   383,   369,   32767, 368,   32767
	};

	const unsigned char *k = (const unsigned char *) key;
	uint32		a = 0;
	uint32		b = 0;

	while (keylen--)
	{
		unsigned char c = *k++ | 0x20;

		a = a * 257 + c;
		b = b * 31 + c;
	}
	return h[a % 943] + h[b % 943];
}

const ScanKeywordList ScanKeywords = {
	ScanKeywords_kw_string,
	ScanKeywords_kw_offsets,
	ScanKeywords_hash_func,
	SCANKEYWORDS_NUM_KEYWORDS,
	17
};

#endif							/* KWLIST_D_H */
