
# https://github.com/jmettraux/rufus-scheduler/issues/259
# https://github.com/floraison/fugit/issues/1

# Are there transitions for which the canonical week goes from odd to odd
# (or even even to even)?


require 'time'
require 'date'


(1970..2050).each do |y|

  (25..31).each do |md|

    t0 = Time.parse("#{y}-12-#{md}")
    t1 = t0 + 7 * 24 * 3600
    st0 = t0.strftime('%F')
    st1 = t1.strftime('%F')

    d0 = Date.parse(st0)
    d1 = Date.parse(st1)

    next unless d0.cweek % 2 == d1.cweek % 2

    p [ st0, t0.strftime('%a'), d0.cweek, st1, t1.strftime('%a'), d1.cweek ]
  end
end

# result:
#
# ["1970-12-28", "Mon", 53, "1971-01-04", "Mon", 1]
# ["1970-12-29", "Tue", 53, "1971-01-05", "Tue", 1]
# ["1970-12-30", "Wed", 53, "1971-01-06", "Wed", 1]
# ["1970-12-31", "Thu", 53, "1971-01-07", "Thu", 1]
# ["1976-12-27", "Mon", 53, "1977-01-03", "Mon", 1]
# ["1976-12-28", "Tue", 53, "1977-01-04", "Tue", 1]
# ["1976-12-29", "Wed", 53, "1977-01-05", "Wed", 1]
# ["1976-12-30", "Thu", 53, "1977-01-06", "Thu", 1]
# ["1976-12-31", "Fri", 53, "1977-01-07", "Fri", 1]
# ["1981-12-28", "Mon", 53, "1982-01-04", "Mon", 1]
# ["1981-12-29", "Tue", 53, "1982-01-05", "Tue", 1]
# ["1981-12-30", "Wed", 53, "1982-01-06", "Wed", 1]
# ["1981-12-31", "Thu", 53, "1982-01-07", "Thu", 1]
# ["1987-12-28", "Mon", 53, "1988-01-04", "Mon", 1]
# ["1987-12-29", "Tue", 53, "1988-01-05", "Tue", 1]
# ["1987-12-30", "Wed", 53, "1988-01-06", "Wed", 1]
# ["1987-12-31", "Thu", 53, "1988-01-07", "Thu", 1]
# ["1992-12-28", "Mon", 53, "1993-01-04", "Mon", 1]
# ["1992-12-29", "Tue", 53, "1993-01-05", "Tue", 1]
# ["1992-12-30", "Wed", 53, "1993-01-06", "Wed", 1]
# ["1992-12-31", "Thu", 53, "1993-01-07", "Thu", 1]
# ["1998-12-28", "Mon", 53, "1999-01-04", "Mon", 1]
# ["1998-12-29", "Tue", 53, "1999-01-05", "Tue", 1]
# ["1998-12-30", "Wed", 53, "1999-01-06", "Wed", 1]
# ["1998-12-31", "Thu", 53, "1999-01-07", "Thu", 1]
# ["2004-12-27", "Mon", 53, "2005-01-03", "Mon", 1]
# ["2004-12-28", "Tue", 53, "2005-01-04", "Tue", 1]
# ["2004-12-29", "Wed", 53, "2005-01-05", "Wed", 1]
# ["2004-12-30", "Thu", 53, "2005-01-06", "Thu", 1]
# ["2004-12-31", "Fri", 53, "2005-01-07", "Fri", 1]
# ["2009-12-28", "Mon", 53, "2010-01-04", "Mon", 1]
# ["2009-12-29", "Tue", 53, "2010-01-05", "Tue", 1]
# ["2009-12-30", "Wed", 53, "2010-01-06", "Wed", 1]
# ["2009-12-31", "Thu", 53, "2010-01-07", "Thu", 1]
# ["2015-12-28", "Mon", 53, "2016-01-04", "Mon", 1]
# ["2015-12-29", "Tue", 53, "2016-01-05", "Tue", 1]
# ["2015-12-30", "Wed", 53, "2016-01-06", "Wed", 1]
# ["2015-12-31", "Thu", 53, "2016-01-07", "Thu", 1]
# ["2020-12-28", "Mon", 53, "2021-01-04", "Mon", 1]
# ["2020-12-29", "Tue", 53, "2021-01-05", "Tue", 1]
# ["2020-12-30", "Wed", 53, "2021-01-06", "Wed", 1]
# ["2020-12-31", "Thu", 53, "2021-01-07", "Thu", 1]
# ["2026-12-28", "Mon", 53, "2027-01-04", "Mon", 1]
# ["2026-12-29", "Tue", 53, "2027-01-05", "Tue", 1]
# ["2026-12-30", "Wed", 53, "2027-01-06", "Wed", 1]
# ["2026-12-31", "Thu", 53, "2027-01-07", "Thu", 1]
# ["2032-12-27", "Mon", 53, "2033-01-03", "Mon", 1]
# ["2032-12-28", "Tue", 53, "2033-01-04", "Tue", 1]
# ["2032-12-29", "Wed", 53, "2033-01-05", "Wed", 1]
# ["2032-12-30", "Thu", 53, "2033-01-06", "Thu", 1]
# ["2032-12-31", "Fri", 53, "2033-01-07", "Fri", 1]
# ["2037-12-28", "Mon", 53, "2038-01-04", "Mon", 1]
# ["2037-12-29", "Tue", 53, "2038-01-05", "Tue", 1]
# ["2037-12-30", "Wed", 53, "2038-01-06", "Wed", 1]
# ["2037-12-31", "Thu", 53, "2038-01-07", "Thu", 1]
# ["2043-12-28", "Mon", 53, "2044-01-04", "Mon", 1]
# ["2043-12-29", "Tue", 53, "2044-01-05", "Tue", 1]
# ["2043-12-30", "Wed", 53, "2044-01-06", "Wed", 1]
# ["2043-12-31", "Thu", 53, "2044-01-07", "Thu", 1]
# ["2048-12-28", "Mon", 53, "2049-01-04", "Mon", 1]
# ["2048-12-29", "Tue", 53, "2049-01-05", "Tue", 1]
# ["2048-12-30", "Wed", 53, "2049-01-06", "Wed", 1]
# ["2048-12-31", "Thu", 53, "2049-01-07", "Thu", 1]

# Yes.

