# Copyright (c) 2015 Red Hat.
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

import os

import debtcollector

__all__ = [
    'subprocess',
]

try:
    import eventlet.patcher
except ImportError:
    _patched_socket = False
else:
    # In tests patching happens later, so we'll rely on environment variable
    _patched_socket = eventlet.patcher.is_monkey_patched('socket') or bool(
        os.environ.get('TEST_EVENTLET', False)
    )

if not _patched_socket:
    import subprocess
else:
    debtcollector.deprecate(
        "Eventlet support is deprecated and will be soon removed."
    )
    from eventlet.green import subprocess  # type: ignore
