# Introduction

All notable changes to this project will be documented in this file.

The format is based on [Keep a
Changelog](https://keepachangelog.com/en/1.0.0/), and this project
adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [2.2.1] - 2026-02-15

### Fixed

- Fix bad release version
- Fix bad doc date

## [2.2.0] - 2026-02-14

### Added

- Add support for including a text message alongside an attachment when creating
  a paste. Pass the message as a positional argument:
  `privatebin create --attachment --filename example.txt "Message to send along"`.
- Add `--proxy` flag for explicit proxy configuration (supports HTTP, HTTPS,
  and SOCKS5 schemes). Useful for routing traffic through TOR
  (e.g. `socks5://127.0.0.1:9050`).
- Add `proxy` configuration option in config file (both top-level and per-bin).
- Proxy resolution priority: `--proxy` flag > config file > environment
  variables (`HTTP_PROXY`, `HTTPS_PROXY`, `ALL_PROXY`).
- Add a clear error message when creating a paste without a configured host.
- Add `privatebin init` command to generate a configuration file with sensible
  defaults. Supports `--host` to set the default instance and `--force` to
  overwrite an existing file.

### Fixed

- Fix error when open paste who never expire

### Changed

- The CLI now works without a configuration file, falling back to sensible
  defaults (expire: 1day, formatter: plaintext, gzip: enabled).
- Configuration file lookup now follows the XDG Base Directory Specification.
  The CLI searches `$HOME/.config/privatebin/config.json`, then
  `$XDG_CONFIG_HOME/privatebin/config.json`, the platform-native user config
  directory, and finally `$XDG_CONFIG_DIRS` (defaults to `/etc/xdg`).
- Remove duplicate error output in the main function.

### Security

- Upgrade to go1.26
- Upgrade go dependencies

## [2.1.1] - 2025-09-08

### Fixed

- Fix various typos throughout the codebase (attachment, unknown).
- Fix MIME type parsing in paste attachments (TrimPrefix -> TrimSuffix).
- Fix MIME type inference bug when no explicit MIME type is provided.
- Adapt GCM implementation for Go 1.21+ compatibility after FIPS 140-3 refactoring broke access to internal gcmAble interface.

### Changed

- Update dependencies.
- Upgrade go version from 1.23 to 1.25.

## [2.1.0] - 2025-08-15

### Added

- Add `skip-tls-verify` configuration option to skip TLS certificate verification.
- Add `--skip-tls-verify` flag to `create` and `show` commands.

### Changed

- Update dependencies.
- Upgrade go version from 1.22 to 1.23.

### Fixed

- Properly handle and log errors from `rootCmd.Execute()` in the main
  function.
- Extra headers not apply to show request.

## [2.0.1] - 2024-04-15

### Fixed

- Top level flags are not handled.

## [2.0.0] - 2024-04-11

### Added

- Add `privatebin show` command.
- Add `privatebin create` command.

### Changed

- Minimal Golang version is now v1.22.
- Minimal PrivateBin instance version is now 1.7.
- Configuration use kebab-case instead of sake-case.

## [1.4.0] - 2023-01-08

### Added

- Add `-gzip` flag to compress data with gzip.

### Changed

- According to OWAP recommendation, increase the number of PBKDF2
  iterations.

## [1.3.0] - 2022-11-06

### Added

- Add `-filename` flag to read file instead of stdin.
- Add `-attachment` flag to update data as an attachment.

### Changed

- Upgrade to Go 1.19.
- Use `gearno.de` import url.

### Fixed

- Create request error not handled.

## [1.2.0] - 2022-09-04

### Added

- Add privatebin version through the `-version` flag.

### Fixed

- Add `User-Agent` request header to mitigate WAF (Cloudflare, etc.)
  blocking request from the CLI.

## [1.1.1] - 2022-07-20

Nothing.

## [1.1.0] - 2022-06-23

### Added

- Add privatebin paste password support. Via the optional `-password`
  flag.

## [1.0.1] - 2022-01-20

### Fixed

- Missing URL path on the returned URL.

## [1.0.0] - 2021-09-06

### Added

- Add privatebin(1) man page.
- Add privatebin.conf(5) man page.

### Changed

- Makefile is now BSD and GNU compatible.
- Configuration file is now stored in the
  `~/.config/privatebin/config.json`.

## [0.1.0] - 2021-05-19

- First release.
