
! Copyright (C) 2002-2005 J. K. Dewhurst, S. Sharma and C. Ambrosch-Draxl.
! This file is distributed under the terms of the GNU Lesser General Public
! License. See the file COPYING for license details.

!BOP
! !ROUTINE: gcd
! !INTERFACE:
integer function gcd(x,y)
! !INPUT/OUTPUT PARAMETERS:
!   x : first integer (in,integer)
!   y : second integer (in,integer)
! !DESCRIPTION:
!   Computes the greatest common divisor (GCD) of two integers using Euclid's
!   algorithm.
!
! !REVISION HISTORY:
!   Created September 2004 (JKD)
!EOP
!BOC
implicit none
! arguments
integer, intent(in) :: x,y
! local variables
integer a,b,c
if ((x < 1).or.(y < 1)) then
  write(*,*)
  write(*,'("Error(gcd): x < 1 or y < 1 :",2(X,I0))') x,y
  write(*,*)
  stop
end if
if (x >= y) then
  a=x
  b=y
else
  a=y
  b=x
end if
10 continue
c=mod(a,b)
a=b
b=c
if (c > 0) goto 10
gcd=a
end function
!EOC

