// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

#pragma once

#include <cstdint>
#include <memory>
#include <string>

#include "arrow/status.h"
#include "arrow/type_fwd.h"
#include "arrow/util/macros.h"
#include "arrow/util/secure_string.h"
#include "parquet/encryption/encryption.h"
#include "parquet/platform.h"

namespace parquet::fuzzing::internal {

struct EncryptionKey {
  ::arrow::util::SecureString key;
  std::string key_metadata;
};

// Generate an encryption key compatible with MakeKeyRetriever
PARQUET_EXPORT EncryptionKey MakeEncryptionKey(int key_len = 16);

// Make a key retriever that is able to retrieve keys generated by MakeEncryptionKey
// and some of the keys used in the parquet-testing data files.
PARQUET_EXPORT std::shared_ptr<DecryptionKeyRetriever> MakeKeyRetriever();

PARQUET_EXPORT ::arrow::Status FuzzReader(const uint8_t* data, int64_t size);

}  // namespace parquet::fuzzing::internal
