/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.NodeDescriptor;
import IceGrid.NodeUpdateDescriptor;
import IceGridGUI.Application.Editable;
import IceGridGUI.Application.ListTreeNode;
import IceGridGUI.Application.Node;
import IceGridGUI.Application.Root;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.ApplicationActions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JPopupMenu;

class Nodes
extends ListTreeNode {
    private Map _descriptors;
    private static JPopupMenu _popup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Map copyDescriptors(Map descriptors) {
        HashMap copy = new HashMap();
        Iterator p = descriptors.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            copy.put(entry.getKey(), Node.copyDescriptor((NodeDescriptor)entry.getValue()));
        }
        return copy;
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        Object descriptor = this.getCoordinator().getClipboard();
        if (descriptor != null) {
            actions[14] = descriptor instanceof NodeDescriptor;
        }
        actions[2] = true;
        return actions;
    }

    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(2));
        }
        actions.setTarget(this);
        return _popup;
    }

    public void paste() {
        Object descriptor = this.getCoordinator().getClipboard();
        this.newNode(Node.copyDescriptor((NodeDescriptor)descriptor));
    }

    public void newNode() {
        this.newNode(new NodeDescriptor(new TreeMap(), new LinkedList(), new LinkedList(), "", "", new HashMap()));
    }

    Nodes(TreeNode parent, Map descriptors) throws UpdateFailedException {
        super(false, parent, "Nodes");
        this._descriptors = descriptors;
        Iterator p = this._descriptors.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            String nodeName = (String)entry.getKey();
            NodeDescriptor nodeDescriptor = (NodeDescriptor)entry.getValue();
            this.insertChild(new Node(false, this, nodeName, nodeDescriptor), false);
        }
    }

    void rebuild() throws UpdateFailedException {
        Vector<Node.Backup> backupList = new Vector<Node.Backup>();
        LinkedList editables = new LinkedList();
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            Node node = (Node)p.next();
            try {
                backupList.add(node.rebuild(editables));
            }
            catch (UpdateFailedException e) {
                for (int i = backupList.size() - 1; i >= 0; --i) {
                    ((Node)this._children.get(i)).restore((Node.Backup)backupList.get(i));
                }
                throw e;
            }
        }
        p = editables.iterator();
        while (p.hasNext()) {
            Editable editable = (Editable)p.next();
            editable.markModified();
        }
    }

    void commit() {
        this._editable.commit();
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            Node node = (Node)p.next();
            node.commit();
        }
    }

    LinkedList getUpdates() {
        LinkedList<NodeUpdateDescriptor> updates = new LinkedList<NodeUpdateDescriptor>();
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            Node node = (Node)p.next();
            NodeUpdateDescriptor d = node.getUpdate();
            if (d == null) continue;
            updates.add(d);
        }
        return updates;
    }

    void removeServerInstances(String templateId) {
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            Node node = (Node)p.next();
            node.removeServerInstances(templateId);
        }
    }

    List findServiceInstances(String template) {
        LinkedList result = new LinkedList();
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            Node node = (Node)p.next();
            result.addAll(node.findServiceInstances(template));
        }
        return result;
    }

    void removeServiceInstances(String templateId) {
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            Node node = (Node)p.next();
            node.removeServiceInstances(templateId);
        }
    }

    void update(List updates, String[] removeNodes, Set serverTemplates, Set serviceTemplates) throws UpdateFailedException {
        Root root = this.getRoot();
        this.removeChildren(removeNodes);
        Vector<Node> newChildren = new Vector<Node>();
        HashSet<Node> updatedNodes = new HashSet<Node>();
        Iterator p = updates.iterator();
        while (p.hasNext()) {
            NodeUpdateDescriptor update = (NodeUpdateDescriptor)p.next();
            Node node = this.findNode(update.name);
            if (node == null) {
                NodeDescriptor nodeDescriptor = new NodeDescriptor(update.variables, update.serverInstances, update.servers, update.loadFactor == null ? "" : update.loadFactor.value, update.description == null ? "" : update.description.value, new HashMap());
                this._descriptors.put(update.name, nodeDescriptor);
                node = new Node(false, this, update.name, nodeDescriptor);
                newChildren.add(node);
                continue;
            }
            node.update(update, serverTemplates, serviceTemplates);
            updatedNodes.add(node);
        }
        p = this._children.iterator();
        while (p.hasNext()) {
            Node node = (Node)p.next();
            if (updatedNodes.contains(node)) continue;
            node.update(null, serverTemplates, serviceTemplates);
        }
        this.insertChildren(newChildren, true);
    }

    Node findNode(String nodeName) {
        return (Node)this.findChild(nodeName);
    }

    List findServerInstances(String template) {
        LinkedList result = new LinkedList();
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            Node node = (Node)p.next();
            result.addAll(node.findServerInstances(template));
        }
        return result;
    }

    void removeDescriptor(String nodeName) {
        this._descriptors.remove(nodeName);
    }

    Object getDescriptor() {
        return this._descriptors;
    }

    void tryAdd(String nodeName, NodeDescriptor descriptor) throws UpdateFailedException {
        Node node = new Node(true, this, nodeName, descriptor);
        this.insertChild(node, true);
        this._descriptors.put(nodeName, descriptor);
    }

    private void newNode(NodeDescriptor descriptor) {
        Node node;
        block2: {
            String name = this.makeNewChildId("NewNode");
            node = new Node(this, name, descriptor);
            try {
                this.insertChild(node, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.getRoot().setSelectedNode(node);
    }

    static {
        $assertionsDisabled = !Nodes.class.desiredAssertionStatus();
    }
}

