/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Bindery;
import com.icl.saxon.Binding;
import com.icl.saxon.Context;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.style.Procedure;
import com.icl.saxon.style.SAXONFunction;
import com.icl.saxon.style.XSLGeneralVariable;
import com.icl.saxon.style.XSLTemplate;
import org.xml.sax.SAXException;

public class XSLParam
extends XSLGeneralVariable
implements Binding {
    private int slotNumber;

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void validate() throws SAXException {
        boolean bl;
        super.validate();
        NodeInfo nodeInfo = (NodeInfo)this.getParentNode();
        boolean bl2 = bl = nodeInfo instanceof XSLTemplate || nodeInfo instanceof SAXONFunction;
        if (!bl && !this.global) {
            throw this.styleError("xsl:param must be immediately within a template, function or stylesheet");
        }
        this.checkDuplicateDeclaration();
        if (this.global) {
            this.slotNumber = this.getPrincipalStyleSheet().allocateSlotNumber();
        } else {
            Procedure procedure = this.getOwningProcedure();
            this.slotNumber = procedure.allocateSlotNumber();
        }
    }

    public void process(Context context) throws SAXException {
        Bindery bindery = context.getBindery();
        boolean bl = this.global ? bindery.useGlobalParameter(this.variableName, this) : bindery.useLocalParameter(this.variableName, this);
        if (!bl) {
            Value value = this.getSelectValue(context);
            if (this.global) {
                bindery.defineGlobalVariable(this, value);
            } else {
                bindery.defineLocalVariable(this, value);
            }
        }
    }

    public int getDataType() {
        return -1;
    }

    public Value constantValue() {
        return null;
    }
}

