#!/usr/bin/python

"""
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
"""

__version__ = "$Revision: 1.34 $"
# $Source: /cvsroot/quantlib/QuantLib-Python/QuantLib/test/QuantLibTestSuite.py,v $

import sys
import unittest

def test():
    import QuantLib
    print 'testing QuantLib', QuantLib.__version__, QuantLib.QuantLibc.__file__, QuantLib.__file__

    suite = unittest.TestSuite()

    from american_option import FdAmericanOptionTest
    suite.addTest(FdAmericanOptionTest())

    from barrier_option import BarrierOptionTest
    suite.addTest(BarrierOptionTest())

    from binary_option import BinaryOptionTest
    suite.addTest(BinaryOptionTest())

    from capfloor import CapFloorTest
    suite.addTest(unittest.makeSuite(CapFloorTest,'test'))

    from cliquet_option import CliquetOptionTest
    suite.addTest(CliquetOptionTest())

    from complexmarketelements import ComplexMarketElementTest
    suite.addTest(ComplexMarketElementTest())

    from date import DateTest
    suite.addTest(DateTest())

    from daycounters import DayCountersTest
    suite.addTest(DayCountersTest())

    from distributions import DistributionTest
    suite.addTest(DistributionTest())

    from european_option import EuropeanOptionTest
    suite.addTest(EuropeanOptionTest())

    from old_european_option import OldEuropeanOptionTest
    suite.addTest(OldEuropeanOptionTest())

    from european_with_dividends import FdDividendEuropeanOptionTest
    suite.addTest(FdDividendEuropeanOptionTest())

    from finite_difference_european import FDEuropeanOptionTest
    suite.addTest(FDEuropeanOptionTest())

    from forwardspreadedcurve import ForwardSpreadedTest
    suite.addTest(ForwardSpreadedTest())

    from get_covariance import CovarianceTest
    suite.addTest(CovarianceTest())

    from implied_volatility import ImpliedVolatilityTest
    suite.addTest(ImpliedVolatilityTest())

    from old_implied_volatility import OldImpliedVolatilityTest
    suite.addTest(OldImpliedVolatilityTest())

    from mcmultifactorpricers import McMultiFactorPricersTest
    suite.addTest(McMultiFactorPricersTest())

    from montecarlo_pricers import MonteCarloPricerTest
    suite.addTest(MonteCarloPricerTest())

    from piecewiseflatforward import PiecewiseFlatForwardTest
    suite.addTest(PiecewiseFlatForwardTest())

    # This didn't test jack
    # from random_generators import RNGTest
    # suite.addTest(RNGTest())

    from risk_statistics import RiskStatisticsTest
    suite.addTest(RiskStatisticsTest())

    from segmentintegral import SegmentIntegralTest
    suite.addTest(SegmentIntegralTest())

    from statistics import StatisticsTest
    suite.addTest(StatisticsTest())

    from swap import SimpleSwapTest
    suite.addTest(SimpleSwapTest())

    from swaption import SwaptionTest
    suite.addTest(unittest.makeSuite(SwaptionTest,'test'))

    result = unittest.TextTestRunner(verbosity=2).run(suite)

    if not result.wasSuccessful:
        sys.exit(1)

if __name__ == '__main__':
    test()
