
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Exercise.i,v 1.1 2002/03/13 16:10:41 lballabio Exp $


#ifndef quantlib_exercise_i
#define quantlib_exercise_i

%{
using QuantLib::Exercise;
typedef Exercise::Type ExerciseType;
using QuantLib::StringFormatter;
%}

%typemap(python,in) ExerciseType (ExerciseType temp),
                    const ExerciseType & (ExerciseType temp) {
    if (PyString_Check($source)) {
        std::string s(PyString_AsString($source));
        s = StringFormatter::toLowercase(s);
        if (s == "e" || s == "european")      temp = Exercise::European;
        else if (s == "a" || s == "american") temp = Exercise::American;
        else if (s == "b" || s == "bermudan") temp = Exercise::Bermudan;
        else {
            PyErr_SetString(PyExc_TypeError,"unknown exercise type");
            return NULL;
        }
    } else {
        PyErr_SetString(PyExc_TypeError,"not an exercise type");
        return NULL;
    }
    $target = &temp;
};

%typemap(python,out) ExerciseType, const ExerciseType & {
    switch (*$source) {
      case Exercise::European:
        $target = PyString_FromString("European"); break;
      case Exercise::American:
        $target = PyString_FromString("American"); break;
      case Exercise::Bermudan:
        $target = PyString_FromString("Bermudan"); break;
      default:
        throw Error("unknown exercise type");
    }
};

%typemap(python,ret) ExerciseType {
    delete $source;
}


class Exercise {
  public:
    Exercise(ExerciseType type, const DateVector& dates);
    ~Exercise();
};

%{
using QuantLib::EuropeanExercise;
using QuantLib::AmericanExercise;
using QuantLib::BermudanExercise;
%}

class EuropeanExercise : public Exercise {
  public:
    EuropeanExercise(Date date);
    ~EuropeanExercise();
};

class AmericanExercise : public Exercise {
  public:
    AmericanExercise(Date earliestDate, Date latestDate);
    ~AmericanExercise();
};

class BermudanExercise : public Exercise {
  public:
    BermudanExercise(const DateVector& dates);
    ~BermudanExercise();
};


#endif
