/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class NameAndTypeShrinker
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
AttributeVisitor {
    private static final Object USED = new Object();
    private int[] constantIndexMap;
    private final ConstantPoolRemapper constantPoolRemapper = new ConstantPoolRemapper();

    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(this);
        programClass.attributesAccept(this);
        int n = this.shrinkConstantPool(programClass.constantPool, programClass.u2constantPoolCount);
        if (n < programClass.u2constantPoolCount) {
            programClass.u2constantPoolCount = n;
            this.constantPoolRemapper.setConstantIndexMap(this.constantIndexMap);
            this.constantPoolRemapper.visitProgramClass(programClass);
        }
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        this.markNameAndTypeConstant(clazz, invokeDynamicConstant.u2nameAndTypeIndex);
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        this.markNameAndTypeConstant(clazz, refConstant.u2nameAndTypeIndex);
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        if (enclosingMethodAttribute.u2nameAndTypeIndex != 0) {
            this.markNameAndTypeConstant(clazz, enclosingMethodAttribute.u2nameAndTypeIndex);
        }
    }

    private void markNameAndTypeConstant(Clazz clazz, int n) {
        this.markAsUsed((NameAndTypeConstant)((ProgramClass)clazz).getConstant(n));
    }

    private void markAsUsed(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(USED);
    }

    private boolean isUsed(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() == USED;
    }

    private int shrinkConstantPool(Constant[] constantArray, int n) {
        if (this.constantIndexMap == null || this.constantIndexMap.length < n) {
            this.constantIndexMap = new int[n];
        }
        int n2 = 1;
        boolean bl = false;
        for (int i = 1; i < n; ++i) {
            this.constantIndexMap[i] = n2;
            Constant constant = constantArray[i];
            if (constant != null) {
                boolean bl2 = bl = constant.getTag() != 12 || this.isUsed(constant);
            }
            if (!bl) continue;
            constantArray[n2++] = constant;
        }
        Arrays.fill(constantArray, n2, n, null);
        return n2;
    }
}

