// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Protocol Buffer 2 Copyright 2008 Google Inc.
// All other code copyright its respective owners.

/**
 * @fileoverview Generated Protocol Buffer code for file
 * third_party/sketchology/proto/document.proto.
 * Generated by //net/proto2/compiler/public:protocol_compiler.
 * @suppress {messageConventions} 
 */

goog.provide('sketchology.proto.Color');
goog.provide('sketchology.proto.BackgroundColor');
goog.provide('sketchology.proto.PageProperties');
goog.provide('sketchology.proto.AddAction');
goog.provide('sketchology.proto.RemoveAction');
goog.provide('sketchology.proto.ClearAction');
goog.provide('sketchology.proto.ReplaceAction');
goog.provide('sketchology.proto.SetTransformAction');
goog.provide('sketchology.proto.SetPageBoundsAction');
goog.provide('sketchology.proto.StorageAction');
goog.provide('sketchology.proto.Snapshot');
goog.provide('sketchology.proto.MutationPacket');
goog.provide('sketchology.proto.StorageActionState');
goog.provide('sketchology.proto.ElementState');

goog.require('goog.proto2.Message');
goog.require('sketchology.proto.AffineTransform');
goog.require('sketchology.proto.BackgroundImageInfo');
goog.require('sketchology.proto.Border');
goog.require('sketchology.proto.ElementBundle');
goog.require('sketchology.proto.Rect');


/**
 * Enumeration StorageActionState.
 * @enum {number}
 */
sketchology.proto.StorageActionState = {
  APPLIED: 1,
  UNDONE: 2
};


/**
 * Enumeration ElementState.
 * @enum {number}
 */
sketchology.proto.ElementState = {
  ALIVE: 1,
  DEAD: 2
};



/**
 * Message Color.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.Color = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.Color, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.Color.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.Color} The cloned message.
 * @override
 */
sketchology.proto.Color.prototype.clone;


/**
 * Gets the value of the argb field.
 * @return {?number} The value.
 */
sketchology.proto.Color.prototype.getArgb = function() {
  return /** @type {?number} */ (this.get$Value(1));
};


/**
 * Gets the value of the argb field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.Color.prototype.getArgbOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the argb field.
 * @param {number} value The value.
 */
sketchology.proto.Color.prototype.setArgb = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the argb field has a value.
 */
sketchology.proto.Color.prototype.hasArgb = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the argb field.
 */
sketchology.proto.Color.prototype.argbCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the argb field.
 */
sketchology.proto.Color.prototype.clearArgb = function() {
  this.clear$Field(1);
};



/**
 * Message BackgroundColor.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.BackgroundColor = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.BackgroundColor, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.BackgroundColor.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.BackgroundColor} The cloned message.
 * @override
 */
sketchology.proto.BackgroundColor.prototype.clone;


/**
 * Gets the value of the rgba field.
 * @return {?number} The value.
 */
sketchology.proto.BackgroundColor.prototype.getRgba = function() {
  return /** @type {?number} */ (this.get$Value(1));
};


/**
 * Gets the value of the rgba field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.BackgroundColor.prototype.getRgbaOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the rgba field.
 * @param {number} value The value.
 */
sketchology.proto.BackgroundColor.prototype.setRgba = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the rgba field has a value.
 */
sketchology.proto.BackgroundColor.prototype.hasRgba = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the rgba field.
 */
sketchology.proto.BackgroundColor.prototype.rgbaCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the rgba field.
 */
sketchology.proto.BackgroundColor.prototype.clearRgba = function() {
  this.clear$Field(1);
};



/**
 * Message PageProperties.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.PageProperties = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.PageProperties, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.PageProperties.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.PageProperties} The cloned message.
 * @override
 */
sketchology.proto.PageProperties.prototype.clone;


/**
 * Gets the value of the background_color field.
 * @return {?sketchology.proto.Color} The value.
 */
sketchology.proto.PageProperties.prototype.getBackgroundColor = function() {
  return /** @type {?sketchology.proto.Color} */ (this.get$Value(1));
};


/**
 * Gets the value of the background_color field or the default value if not set.
 * @return {!sketchology.proto.Color} The value.
 */
sketchology.proto.PageProperties.prototype.getBackgroundColorOrDefault = function() {
  return /** @type {!sketchology.proto.Color} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the background_color field.
 * @param {!sketchology.proto.Color} value The value.
 */
sketchology.proto.PageProperties.prototype.setBackgroundColor = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the background_color field has a value.
 */
sketchology.proto.PageProperties.prototype.hasBackgroundColor = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the background_color field.
 */
sketchology.proto.PageProperties.prototype.backgroundColorCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the background_color field.
 */
sketchology.proto.PageProperties.prototype.clearBackgroundColor = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the background_image field.
 * @return {?sketchology.proto.BackgroundImageInfo} The value.
 */
sketchology.proto.PageProperties.prototype.getBackgroundImage = function() {
  return /** @type {?sketchology.proto.BackgroundImageInfo} */ (this.get$Value(2));
};


/**
 * Gets the value of the background_image field or the default value if not set.
 * @return {!sketchology.proto.BackgroundImageInfo} The value.
 */
sketchology.proto.PageProperties.prototype.getBackgroundImageOrDefault = function() {
  return /** @type {!sketchology.proto.BackgroundImageInfo} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the background_image field.
 * @param {!sketchology.proto.BackgroundImageInfo} value The value.
 */
sketchology.proto.PageProperties.prototype.setBackgroundImage = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the background_image field has a value.
 */
sketchology.proto.PageProperties.prototype.hasBackgroundImage = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the background_image field.
 */
sketchology.proto.PageProperties.prototype.backgroundImageCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the background_image field.
 */
sketchology.proto.PageProperties.prototype.clearBackgroundImage = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the bounds field.
 * @return {?sketchology.proto.Rect} The value.
 */
sketchology.proto.PageProperties.prototype.getBounds = function() {
  return /** @type {?sketchology.proto.Rect} */ (this.get$Value(3));
};


/**
 * Gets the value of the bounds field or the default value if not set.
 * @return {!sketchology.proto.Rect} The value.
 */
sketchology.proto.PageProperties.prototype.getBoundsOrDefault = function() {
  return /** @type {!sketchology.proto.Rect} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the bounds field.
 * @param {!sketchology.proto.Rect} value The value.
 */
sketchology.proto.PageProperties.prototype.setBounds = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the bounds field has a value.
 */
sketchology.proto.PageProperties.prototype.hasBounds = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the bounds field.
 */
sketchology.proto.PageProperties.prototype.boundsCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the bounds field.
 */
sketchology.proto.PageProperties.prototype.clearBounds = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the border field.
 * @return {?sketchology.proto.Border} The value.
 */
sketchology.proto.PageProperties.prototype.getBorder = function() {
  return /** @type {?sketchology.proto.Border} */ (this.get$Value(4));
};


/**
 * Gets the value of the border field or the default value if not set.
 * @return {!sketchology.proto.Border} The value.
 */
sketchology.proto.PageProperties.prototype.getBorderOrDefault = function() {
  return /** @type {!sketchology.proto.Border} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the border field.
 * @param {!sketchology.proto.Border} value The value.
 */
sketchology.proto.PageProperties.prototype.setBorder = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the border field has a value.
 */
sketchology.proto.PageProperties.prototype.hasBorder = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the border field.
 */
sketchology.proto.PageProperties.prototype.borderCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the border field.
 */
sketchology.proto.PageProperties.prototype.clearBorder = function() {
  this.clear$Field(4);
};



/**
 * Message AddAction.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.AddAction = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.AddAction, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.AddAction.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.AddAction} The cloned message.
 * @override
 */
sketchology.proto.AddAction.prototype.clone;


/**
 * Gets the value of the uuid field.
 * @return {?string} The value.
 */
sketchology.proto.AddAction.prototype.getUuid = function() {
  return /** @type {?string} */ (this.get$Value(1));
};


/**
 * Gets the value of the uuid field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.AddAction.prototype.getUuidOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the uuid field.
 * @param {string} value The value.
 */
sketchology.proto.AddAction.prototype.setUuid = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the uuid field has a value.
 */
sketchology.proto.AddAction.prototype.hasUuid = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uuid field.
 */
sketchology.proto.AddAction.prototype.uuidCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uuid field.
 */
sketchology.proto.AddAction.prototype.clearUuid = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the below_element_with_uuid field.
 * @return {?string} The value.
 */
sketchology.proto.AddAction.prototype.getBelowElementWithUuid = function() {
  return /** @type {?string} */ (this.get$Value(2));
};


/**
 * Gets the value of the below_element_with_uuid field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.AddAction.prototype.getBelowElementWithUuidOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the below_element_with_uuid field.
 * @param {string} value The value.
 */
sketchology.proto.AddAction.prototype.setBelowElementWithUuid = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the below_element_with_uuid field has a value.
 */
sketchology.proto.AddAction.prototype.hasBelowElementWithUuid = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the below_element_with_uuid field.
 */
sketchology.proto.AddAction.prototype.belowElementWithUuidCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the below_element_with_uuid field.
 */
sketchology.proto.AddAction.prototype.clearBelowElementWithUuid = function() {
  this.clear$Field(2);
};



/**
 * Message RemoveAction.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.RemoveAction = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.RemoveAction, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.RemoveAction.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.RemoveAction} The cloned message.
 * @override
 */
sketchology.proto.RemoveAction.prototype.clone;


/**
 * Gets the value of the uuid field at the index given.
 * @param {number} index The index to lookup.
 * @return {?string} The value.
 */
sketchology.proto.RemoveAction.prototype.getUuid = function(index) {
  return /** @type {?string} */ (this.get$Value(1, index));
};


/**
 * Gets the value of the uuid field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {string} The value.
 */
sketchology.proto.RemoveAction.prototype.getUuidOrDefault = function(index) {
  return /** @type {string} */ (this.get$ValueOrDefault(1, index));
};


/**
 * Adds a value to the uuid field.
 * @param {string} value The value to add.
 */
sketchology.proto.RemoveAction.prototype.addUuid = function(value) {
  this.add$Value(1, value);
};


/**
 * Returns the array of values in the uuid field.
 * @return {!Array<string>} The values in the field.
 */
sketchology.proto.RemoveAction.prototype.uuidArray = function() {
  return /** @type {!Array<string>} */ (this.array$Values(1));
};


/**
 * @return {boolean} Whether the uuid field has a value.
 */
sketchology.proto.RemoveAction.prototype.hasUuid = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uuid field.
 */
sketchology.proto.RemoveAction.prototype.uuidCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uuid field.
 */
sketchology.proto.RemoveAction.prototype.clearUuid = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the was_below_uuid field at the index given.
 * @param {number} index The index to lookup.
 * @return {?string} The value.
 */
sketchology.proto.RemoveAction.prototype.getWasBelowUuid = function(index) {
  return /** @type {?string} */ (this.get$Value(2, index));
};


/**
 * Gets the value of the was_below_uuid field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {string} The value.
 */
sketchology.proto.RemoveAction.prototype.getWasBelowUuidOrDefault = function(index) {
  return /** @type {string} */ (this.get$ValueOrDefault(2, index));
};


/**
 * Adds a value to the was_below_uuid field.
 * @param {string} value The value to add.
 */
sketchology.proto.RemoveAction.prototype.addWasBelowUuid = function(value) {
  this.add$Value(2, value);
};


/**
 * Returns the array of values in the was_below_uuid field.
 * @return {!Array<string>} The values in the field.
 */
sketchology.proto.RemoveAction.prototype.wasBelowUuidArray = function() {
  return /** @type {!Array<string>} */ (this.array$Values(2));
};


/**
 * @return {boolean} Whether the was_below_uuid field has a value.
 */
sketchology.proto.RemoveAction.prototype.hasWasBelowUuid = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the was_below_uuid field.
 */
sketchology.proto.RemoveAction.prototype.wasBelowUuidCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the was_below_uuid field.
 */
sketchology.proto.RemoveAction.prototype.clearWasBelowUuid = function() {
  this.clear$Field(2);
};



/**
 * Message ClearAction.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.ClearAction = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.ClearAction, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.ClearAction.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.ClearAction} The cloned message.
 * @override
 */
sketchology.proto.ClearAction.prototype.clone;


/**
 * Gets the value of the uuid field at the index given.
 * @param {number} index The index to lookup.
 * @return {?string} The value.
 */
sketchology.proto.ClearAction.prototype.getUuid = function(index) {
  return /** @type {?string} */ (this.get$Value(1, index));
};


/**
 * Gets the value of the uuid field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {string} The value.
 */
sketchology.proto.ClearAction.prototype.getUuidOrDefault = function(index) {
  return /** @type {string} */ (this.get$ValueOrDefault(1, index));
};


/**
 * Adds a value to the uuid field.
 * @param {string} value The value to add.
 */
sketchology.proto.ClearAction.prototype.addUuid = function(value) {
  this.add$Value(1, value);
};


/**
 * Returns the array of values in the uuid field.
 * @return {!Array<string>} The values in the field.
 */
sketchology.proto.ClearAction.prototype.uuidArray = function() {
  return /** @type {!Array<string>} */ (this.array$Values(1));
};


/**
 * @return {boolean} Whether the uuid field has a value.
 */
sketchology.proto.ClearAction.prototype.hasUuid = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uuid field.
 */
sketchology.proto.ClearAction.prototype.uuidCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uuid field.
 */
sketchology.proto.ClearAction.prototype.clearUuid = function() {
  this.clear$Field(1);
};



/**
 * Message ReplaceAction.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.ReplaceAction = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.ReplaceAction, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.ReplaceAction.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.ReplaceAction} The cloned message.
 * @override
 */
sketchology.proto.ReplaceAction.prototype.clone;


/**
 * Gets the value of the uuid_add field at the index given.
 * @param {number} index The index to lookup.
 * @return {?string} The value.
 */
sketchology.proto.ReplaceAction.prototype.getUuidAdd = function(index) {
  return /** @type {?string} */ (this.get$Value(1, index));
};


/**
 * Gets the value of the uuid_add field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {string} The value.
 */
sketchology.proto.ReplaceAction.prototype.getUuidAddOrDefault = function(index) {
  return /** @type {string} */ (this.get$ValueOrDefault(1, index));
};


/**
 * Adds a value to the uuid_add field.
 * @param {string} value The value to add.
 */
sketchology.proto.ReplaceAction.prototype.addUuidAdd = function(value) {
  this.add$Value(1, value);
};


/**
 * Returns the array of values in the uuid_add field.
 * @return {!Array<string>} The values in the field.
 */
sketchology.proto.ReplaceAction.prototype.uuidAddArray = function() {
  return /** @type {!Array<string>} */ (this.array$Values(1));
};


/**
 * @return {boolean} Whether the uuid_add field has a value.
 */
sketchology.proto.ReplaceAction.prototype.hasUuidAdd = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uuid_add field.
 */
sketchology.proto.ReplaceAction.prototype.uuidAddCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uuid_add field.
 */
sketchology.proto.ReplaceAction.prototype.clearUuidAdd = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the below_element_with_uuid field.
 * @return {?string} The value.
 */
sketchology.proto.ReplaceAction.prototype.getBelowElementWithUuid = function() {
  return /** @type {?string} */ (this.get$Value(2));
};


/**
 * Gets the value of the below_element_with_uuid field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.ReplaceAction.prototype.getBelowElementWithUuidOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the below_element_with_uuid field.
 * @param {string} value The value.
 */
sketchology.proto.ReplaceAction.prototype.setBelowElementWithUuid = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the below_element_with_uuid field has a value.
 */
sketchology.proto.ReplaceAction.prototype.hasBelowElementWithUuid = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the below_element_with_uuid field.
 */
sketchology.proto.ReplaceAction.prototype.belowElementWithUuidCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the below_element_with_uuid field.
 */
sketchology.proto.ReplaceAction.prototype.clearBelowElementWithUuid = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the uuid_remove field at the index given.
 * @param {number} index The index to lookup.
 * @return {?string} The value.
 */
sketchology.proto.ReplaceAction.prototype.getUuidRemove = function(index) {
  return /** @type {?string} */ (this.get$Value(3, index));
};


/**
 * Gets the value of the uuid_remove field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {string} The value.
 */
sketchology.proto.ReplaceAction.prototype.getUuidRemoveOrDefault = function(index) {
  return /** @type {string} */ (this.get$ValueOrDefault(3, index));
};


/**
 * Adds a value to the uuid_remove field.
 * @param {string} value The value to add.
 */
sketchology.proto.ReplaceAction.prototype.addUuidRemove = function(value) {
  this.add$Value(3, value);
};


/**
 * Returns the array of values in the uuid_remove field.
 * @return {!Array<string>} The values in the field.
 */
sketchology.proto.ReplaceAction.prototype.uuidRemoveArray = function() {
  return /** @type {!Array<string>} */ (this.array$Values(3));
};


/**
 * @return {boolean} Whether the uuid_remove field has a value.
 */
sketchology.proto.ReplaceAction.prototype.hasUuidRemove = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the uuid_remove field.
 */
sketchology.proto.ReplaceAction.prototype.uuidRemoveCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the uuid_remove field.
 */
sketchology.proto.ReplaceAction.prototype.clearUuidRemove = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the was_below_uuid field at the index given.
 * @param {number} index The index to lookup.
 * @return {?string} The value.
 */
sketchology.proto.ReplaceAction.prototype.getWasBelowUuid = function(index) {
  return /** @type {?string} */ (this.get$Value(4, index));
};


/**
 * Gets the value of the was_below_uuid field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {string} The value.
 */
sketchology.proto.ReplaceAction.prototype.getWasBelowUuidOrDefault = function(index) {
  return /** @type {string} */ (this.get$ValueOrDefault(4, index));
};


/**
 * Adds a value to the was_below_uuid field.
 * @param {string} value The value to add.
 */
sketchology.proto.ReplaceAction.prototype.addWasBelowUuid = function(value) {
  this.add$Value(4, value);
};


/**
 * Returns the array of values in the was_below_uuid field.
 * @return {!Array<string>} The values in the field.
 */
sketchology.proto.ReplaceAction.prototype.wasBelowUuidArray = function() {
  return /** @type {!Array<string>} */ (this.array$Values(4));
};


/**
 * @return {boolean} Whether the was_below_uuid field has a value.
 */
sketchology.proto.ReplaceAction.prototype.hasWasBelowUuid = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the was_below_uuid field.
 */
sketchology.proto.ReplaceAction.prototype.wasBelowUuidCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the was_below_uuid field.
 */
sketchology.proto.ReplaceAction.prototype.clearWasBelowUuid = function() {
  this.clear$Field(4);
};



/**
 * Message SetTransformAction.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.SetTransformAction = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.SetTransformAction, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.SetTransformAction.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.SetTransformAction} The cloned message.
 * @override
 */
sketchology.proto.SetTransformAction.prototype.clone;


/**
 * Gets the value of the uuid field at the index given.
 * @param {number} index The index to lookup.
 * @return {?string} The value.
 */
sketchology.proto.SetTransformAction.prototype.getUuid = function(index) {
  return /** @type {?string} */ (this.get$Value(1, index));
};


/**
 * Gets the value of the uuid field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {string} The value.
 */
sketchology.proto.SetTransformAction.prototype.getUuidOrDefault = function(index) {
  return /** @type {string} */ (this.get$ValueOrDefault(1, index));
};


/**
 * Adds a value to the uuid field.
 * @param {string} value The value to add.
 */
sketchology.proto.SetTransformAction.prototype.addUuid = function(value) {
  this.add$Value(1, value);
};


/**
 * Returns the array of values in the uuid field.
 * @return {!Array<string>} The values in the field.
 */
sketchology.proto.SetTransformAction.prototype.uuidArray = function() {
  return /** @type {!Array<string>} */ (this.array$Values(1));
};


/**
 * @return {boolean} Whether the uuid field has a value.
 */
sketchology.proto.SetTransformAction.prototype.hasUuid = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uuid field.
 */
sketchology.proto.SetTransformAction.prototype.uuidCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uuid field.
 */
sketchology.proto.SetTransformAction.prototype.clearUuid = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the from_transform field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.AffineTransform} The value.
 */
sketchology.proto.SetTransformAction.prototype.getFromTransform = function(index) {
  return /** @type {?sketchology.proto.AffineTransform} */ (this.get$Value(2, index));
};


/**
 * Gets the value of the from_transform field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.AffineTransform} The value.
 */
sketchology.proto.SetTransformAction.prototype.getFromTransformOrDefault = function(index) {
  return /** @type {!sketchology.proto.AffineTransform} */ (this.get$ValueOrDefault(2, index));
};


/**
 * Adds a value to the from_transform field.
 * @param {!sketchology.proto.AffineTransform} value The value to add.
 */
sketchology.proto.SetTransformAction.prototype.addFromTransform = function(value) {
  this.add$Value(2, value);
};


/**
 * Returns the array of values in the from_transform field.
 * @return {!Array<!sketchology.proto.AffineTransform>} The values in the field.
 */
sketchology.proto.SetTransformAction.prototype.fromTransformArray = function() {
  return /** @type {!Array<!sketchology.proto.AffineTransform>} */ (this.array$Values(2));
};


/**
 * @return {boolean} Whether the from_transform field has a value.
 */
sketchology.proto.SetTransformAction.prototype.hasFromTransform = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the from_transform field.
 */
sketchology.proto.SetTransformAction.prototype.fromTransformCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the from_transform field.
 */
sketchology.proto.SetTransformAction.prototype.clearFromTransform = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the to_transform field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.AffineTransform} The value.
 */
sketchology.proto.SetTransformAction.prototype.getToTransform = function(index) {
  return /** @type {?sketchology.proto.AffineTransform} */ (this.get$Value(3, index));
};


/**
 * Gets the value of the to_transform field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.AffineTransform} The value.
 */
sketchology.proto.SetTransformAction.prototype.getToTransformOrDefault = function(index) {
  return /** @type {!sketchology.proto.AffineTransform} */ (this.get$ValueOrDefault(3, index));
};


/**
 * Adds a value to the to_transform field.
 * @param {!sketchology.proto.AffineTransform} value The value to add.
 */
sketchology.proto.SetTransformAction.prototype.addToTransform = function(value) {
  this.add$Value(3, value);
};


/**
 * Returns the array of values in the to_transform field.
 * @return {!Array<!sketchology.proto.AffineTransform>} The values in the field.
 */
sketchology.proto.SetTransformAction.prototype.toTransformArray = function() {
  return /** @type {!Array<!sketchology.proto.AffineTransform>} */ (this.array$Values(3));
};


/**
 * @return {boolean} Whether the to_transform field has a value.
 */
sketchology.proto.SetTransformAction.prototype.hasToTransform = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the to_transform field.
 */
sketchology.proto.SetTransformAction.prototype.toTransformCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the to_transform field.
 */
sketchology.proto.SetTransformAction.prototype.clearToTransform = function() {
  this.clear$Field(3);
};



/**
 * Message SetPageBoundsAction.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.SetPageBoundsAction = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.SetPageBoundsAction, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.SetPageBoundsAction.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.SetPageBoundsAction} The cloned message.
 * @override
 */
sketchology.proto.SetPageBoundsAction.prototype.clone;


/**
 * Gets the value of the old_bounds field.
 * @return {?sketchology.proto.Rect} The value.
 */
sketchology.proto.SetPageBoundsAction.prototype.getOldBounds = function() {
  return /** @type {?sketchology.proto.Rect} */ (this.get$Value(1));
};


/**
 * Gets the value of the old_bounds field or the default value if not set.
 * @return {!sketchology.proto.Rect} The value.
 */
sketchology.proto.SetPageBoundsAction.prototype.getOldBoundsOrDefault = function() {
  return /** @type {!sketchology.proto.Rect} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the old_bounds field.
 * @param {!sketchology.proto.Rect} value The value.
 */
sketchology.proto.SetPageBoundsAction.prototype.setOldBounds = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the old_bounds field has a value.
 */
sketchology.proto.SetPageBoundsAction.prototype.hasOldBounds = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the old_bounds field.
 */
sketchology.proto.SetPageBoundsAction.prototype.oldBoundsCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the old_bounds field.
 */
sketchology.proto.SetPageBoundsAction.prototype.clearOldBounds = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the new_bounds field.
 * @return {?sketchology.proto.Rect} The value.
 */
sketchology.proto.SetPageBoundsAction.prototype.getNewBounds = function() {
  return /** @type {?sketchology.proto.Rect} */ (this.get$Value(2));
};


/**
 * Gets the value of the new_bounds field or the default value if not set.
 * @return {!sketchology.proto.Rect} The value.
 */
sketchology.proto.SetPageBoundsAction.prototype.getNewBoundsOrDefault = function() {
  return /** @type {!sketchology.proto.Rect} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the new_bounds field.
 * @param {!sketchology.proto.Rect} value The value.
 */
sketchology.proto.SetPageBoundsAction.prototype.setNewBounds = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the new_bounds field has a value.
 */
sketchology.proto.SetPageBoundsAction.prototype.hasNewBounds = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the new_bounds field.
 */
sketchology.proto.SetPageBoundsAction.prototype.newBoundsCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the new_bounds field.
 */
sketchology.proto.SetPageBoundsAction.prototype.clearNewBounds = function() {
  this.clear$Field(2);
};



/**
 * Message StorageAction.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.StorageAction = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.StorageAction, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.StorageAction.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.StorageAction} The cloned message.
 * @override
 */
sketchology.proto.StorageAction.prototype.clone;


/**
 * Gets the value of the add_action field.
 * @return {?sketchology.proto.AddAction} The value.
 */
sketchology.proto.StorageAction.prototype.getAddAction = function() {
  return /** @type {?sketchology.proto.AddAction} */ (this.get$Value(1));
};


/**
 * Gets the value of the add_action field or the default value if not set.
 * @return {!sketchology.proto.AddAction} The value.
 */
sketchology.proto.StorageAction.prototype.getAddActionOrDefault = function() {
  return /** @type {!sketchology.proto.AddAction} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the add_action field.
 * @param {!sketchology.proto.AddAction} value The value.
 */
sketchology.proto.StorageAction.prototype.setAddAction = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the add_action field has a value.
 */
sketchology.proto.StorageAction.prototype.hasAddAction = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the add_action field.
 */
sketchology.proto.StorageAction.prototype.addActionCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the add_action field.
 */
sketchology.proto.StorageAction.prototype.clearAddAction = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the remove_action field.
 * @return {?sketchology.proto.RemoveAction} The value.
 */
sketchology.proto.StorageAction.prototype.getRemoveAction = function() {
  return /** @type {?sketchology.proto.RemoveAction} */ (this.get$Value(2));
};


/**
 * Gets the value of the remove_action field or the default value if not set.
 * @return {!sketchology.proto.RemoveAction} The value.
 */
sketchology.proto.StorageAction.prototype.getRemoveActionOrDefault = function() {
  return /** @type {!sketchology.proto.RemoveAction} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the remove_action field.
 * @param {!sketchology.proto.RemoveAction} value The value.
 */
sketchology.proto.StorageAction.prototype.setRemoveAction = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the remove_action field has a value.
 */
sketchology.proto.StorageAction.prototype.hasRemoveAction = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the remove_action field.
 */
sketchology.proto.StorageAction.prototype.removeActionCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the remove_action field.
 */
sketchology.proto.StorageAction.prototype.clearRemoveAction = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the clear_action field.
 * @return {?sketchology.proto.ClearAction} The value.
 */
sketchology.proto.StorageAction.prototype.getClearAction = function() {
  return /** @type {?sketchology.proto.ClearAction} */ (this.get$Value(3));
};


/**
 * Gets the value of the clear_action field or the default value if not set.
 * @return {!sketchology.proto.ClearAction} The value.
 */
sketchology.proto.StorageAction.prototype.getClearActionOrDefault = function() {
  return /** @type {!sketchology.proto.ClearAction} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the clear_action field.
 * @param {!sketchology.proto.ClearAction} value The value.
 */
sketchology.proto.StorageAction.prototype.setClearAction = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the clear_action field has a value.
 */
sketchology.proto.StorageAction.prototype.hasClearAction = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the clear_action field.
 */
sketchology.proto.StorageAction.prototype.clearActionCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the clear_action field.
 */
sketchology.proto.StorageAction.prototype.clearClearAction = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the replace_action field.
 * @return {?sketchology.proto.ReplaceAction} The value.
 */
sketchology.proto.StorageAction.prototype.getReplaceAction = function() {
  return /** @type {?sketchology.proto.ReplaceAction} */ (this.get$Value(4));
};


/**
 * Gets the value of the replace_action field or the default value if not set.
 * @return {!sketchology.proto.ReplaceAction} The value.
 */
sketchology.proto.StorageAction.prototype.getReplaceActionOrDefault = function() {
  return /** @type {!sketchology.proto.ReplaceAction} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the replace_action field.
 * @param {!sketchology.proto.ReplaceAction} value The value.
 */
sketchology.proto.StorageAction.prototype.setReplaceAction = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the replace_action field has a value.
 */
sketchology.proto.StorageAction.prototype.hasReplaceAction = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the replace_action field.
 */
sketchology.proto.StorageAction.prototype.replaceActionCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the replace_action field.
 */
sketchology.proto.StorageAction.prototype.clearReplaceAction = function() {
  this.clear$Field(4);
};


/**
 * Gets the value of the set_transform_action field.
 * @return {?sketchology.proto.SetTransformAction} The value.
 */
sketchology.proto.StorageAction.prototype.getSetTransformAction = function() {
  return /** @type {?sketchology.proto.SetTransformAction} */ (this.get$Value(5));
};


/**
 * Gets the value of the set_transform_action field or the default value if not set.
 * @return {!sketchology.proto.SetTransformAction} The value.
 */
sketchology.proto.StorageAction.prototype.getSetTransformActionOrDefault = function() {
  return /** @type {!sketchology.proto.SetTransformAction} */ (this.get$ValueOrDefault(5));
};


/**
 * Sets the value of the set_transform_action field.
 * @param {!sketchology.proto.SetTransformAction} value The value.
 */
sketchology.proto.StorageAction.prototype.setSetTransformAction = function(value) {
  this.set$Value(5, value);
};


/**
 * @return {boolean} Whether the set_transform_action field has a value.
 */
sketchology.proto.StorageAction.prototype.hasSetTransformAction = function() {
  return this.has$Value(5);
};


/**
 * @return {number} The number of values in the set_transform_action field.
 */
sketchology.proto.StorageAction.prototype.setTransformActionCount = function() {
  return this.count$Values(5);
};


/**
 * Clears the values in the set_transform_action field.
 */
sketchology.proto.StorageAction.prototype.clearSetTransformAction = function() {
  this.clear$Field(5);
};


/**
 * Gets the value of the set_page_bounds_action field.
 * @return {?sketchology.proto.SetPageBoundsAction} The value.
 */
sketchology.proto.StorageAction.prototype.getSetPageBoundsAction = function() {
  return /** @type {?sketchology.proto.SetPageBoundsAction} */ (this.get$Value(6));
};


/**
 * Gets the value of the set_page_bounds_action field or the default value if not set.
 * @return {!sketchology.proto.SetPageBoundsAction} The value.
 */
sketchology.proto.StorageAction.prototype.getSetPageBoundsActionOrDefault = function() {
  return /** @type {!sketchology.proto.SetPageBoundsAction} */ (this.get$ValueOrDefault(6));
};


/**
 * Sets the value of the set_page_bounds_action field.
 * @param {!sketchology.proto.SetPageBoundsAction} value The value.
 */
sketchology.proto.StorageAction.prototype.setSetPageBoundsAction = function(value) {
  this.set$Value(6, value);
};


/**
 * @return {boolean} Whether the set_page_bounds_action field has a value.
 */
sketchology.proto.StorageAction.prototype.hasSetPageBoundsAction = function() {
  return this.has$Value(6);
};


/**
 * @return {number} The number of values in the set_page_bounds_action field.
 */
sketchology.proto.StorageAction.prototype.setPageBoundsActionCount = function() {
  return this.count$Values(6);
};


/**
 * Clears the values in the set_page_bounds_action field.
 */
sketchology.proto.StorageAction.prototype.clearSetPageBoundsAction = function() {
  this.clear$Field(6);
};



/**
 * Message Snapshot.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.Snapshot = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.Snapshot, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.Snapshot.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.Snapshot} The cloned message.
 * @override
 */
sketchology.proto.Snapshot.prototype.clone;


/**
 * Gets the value of the page_properties field.
 * @return {?sketchology.proto.PageProperties} The value.
 */
sketchology.proto.Snapshot.prototype.getPageProperties = function() {
  return /** @type {?sketchology.proto.PageProperties} */ (this.get$Value(1));
};


/**
 * Gets the value of the page_properties field or the default value if not set.
 * @return {!sketchology.proto.PageProperties} The value.
 */
sketchology.proto.Snapshot.prototype.getPagePropertiesOrDefault = function() {
  return /** @type {!sketchology.proto.PageProperties} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the page_properties field.
 * @param {!sketchology.proto.PageProperties} value The value.
 */
sketchology.proto.Snapshot.prototype.setPageProperties = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the page_properties field has a value.
 */
sketchology.proto.Snapshot.prototype.hasPageProperties = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the page_properties field.
 */
sketchology.proto.Snapshot.prototype.pagePropertiesCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the page_properties field.
 */
sketchology.proto.Snapshot.prototype.clearPageProperties = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the element field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.ElementBundle} The value.
 */
sketchology.proto.Snapshot.prototype.getElement = function(index) {
  return /** @type {?sketchology.proto.ElementBundle} */ (this.get$Value(2, index));
};


/**
 * Gets the value of the element field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.ElementBundle} The value.
 */
sketchology.proto.Snapshot.prototype.getElementOrDefault = function(index) {
  return /** @type {!sketchology.proto.ElementBundle} */ (this.get$ValueOrDefault(2, index));
};


/**
 * Adds a value to the element field.
 * @param {!sketchology.proto.ElementBundle} value The value to add.
 */
sketchology.proto.Snapshot.prototype.addElement = function(value) {
  this.add$Value(2, value);
};


/**
 * Returns the array of values in the element field.
 * @return {!Array<!sketchology.proto.ElementBundle>} The values in the field.
 */
sketchology.proto.Snapshot.prototype.elementArray = function() {
  return /** @type {!Array<!sketchology.proto.ElementBundle>} */ (this.array$Values(2));
};


/**
 * @return {boolean} Whether the element field has a value.
 */
sketchology.proto.Snapshot.prototype.hasElement = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the element field.
 */
sketchology.proto.Snapshot.prototype.elementCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the element field.
 */
sketchology.proto.Snapshot.prototype.clearElement = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the dead_element field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.ElementBundle} The value.
 */
sketchology.proto.Snapshot.prototype.getDeadElement = function(index) {
  return /** @type {?sketchology.proto.ElementBundle} */ (this.get$Value(3, index));
};


/**
 * Gets the value of the dead_element field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.ElementBundle} The value.
 */
sketchology.proto.Snapshot.prototype.getDeadElementOrDefault = function(index) {
  return /** @type {!sketchology.proto.ElementBundle} */ (this.get$ValueOrDefault(3, index));
};


/**
 * Adds a value to the dead_element field.
 * @param {!sketchology.proto.ElementBundle} value The value to add.
 */
sketchology.proto.Snapshot.prototype.addDeadElement = function(value) {
  this.add$Value(3, value);
};


/**
 * Returns the array of values in the dead_element field.
 * @return {!Array<!sketchology.proto.ElementBundle>} The values in the field.
 */
sketchology.proto.Snapshot.prototype.deadElementArray = function() {
  return /** @type {!Array<!sketchology.proto.ElementBundle>} */ (this.array$Values(3));
};


/**
 * @return {boolean} Whether the dead_element field has a value.
 */
sketchology.proto.Snapshot.prototype.hasDeadElement = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the dead_element field.
 */
sketchology.proto.Snapshot.prototype.deadElementCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the dead_element field.
 */
sketchology.proto.Snapshot.prototype.clearDeadElement = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the undo_action field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.StorageAction} The value.
 */
sketchology.proto.Snapshot.prototype.getUndoAction = function(index) {
  return /** @type {?sketchology.proto.StorageAction} */ (this.get$Value(4, index));
};


/**
 * Gets the value of the undo_action field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.StorageAction} The value.
 */
sketchology.proto.Snapshot.prototype.getUndoActionOrDefault = function(index) {
  return /** @type {!sketchology.proto.StorageAction} */ (this.get$ValueOrDefault(4, index));
};


/**
 * Adds a value to the undo_action field.
 * @param {!sketchology.proto.StorageAction} value The value to add.
 */
sketchology.proto.Snapshot.prototype.addUndoAction = function(value) {
  this.add$Value(4, value);
};


/**
 * Returns the array of values in the undo_action field.
 * @return {!Array<!sketchology.proto.StorageAction>} The values in the field.
 */
sketchology.proto.Snapshot.prototype.undoActionArray = function() {
  return /** @type {!Array<!sketchology.proto.StorageAction>} */ (this.array$Values(4));
};


/**
 * @return {boolean} Whether the undo_action field has a value.
 */
sketchology.proto.Snapshot.prototype.hasUndoAction = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the undo_action field.
 */
sketchology.proto.Snapshot.prototype.undoActionCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the undo_action field.
 */
sketchology.proto.Snapshot.prototype.clearUndoAction = function() {
  this.clear$Field(4);
};


/**
 * Gets the value of the redo_action field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.StorageAction} The value.
 */
sketchology.proto.Snapshot.prototype.getRedoAction = function(index) {
  return /** @type {?sketchology.proto.StorageAction} */ (this.get$Value(5, index));
};


/**
 * Gets the value of the redo_action field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.StorageAction} The value.
 */
sketchology.proto.Snapshot.prototype.getRedoActionOrDefault = function(index) {
  return /** @type {!sketchology.proto.StorageAction} */ (this.get$ValueOrDefault(5, index));
};


/**
 * Adds a value to the redo_action field.
 * @param {!sketchology.proto.StorageAction} value The value to add.
 */
sketchology.proto.Snapshot.prototype.addRedoAction = function(value) {
  this.add$Value(5, value);
};


/**
 * Returns the array of values in the redo_action field.
 * @return {!Array<!sketchology.proto.StorageAction>} The values in the field.
 */
sketchology.proto.Snapshot.prototype.redoActionArray = function() {
  return /** @type {!Array<!sketchology.proto.StorageAction>} */ (this.array$Values(5));
};


/**
 * @return {boolean} Whether the redo_action field has a value.
 */
sketchology.proto.Snapshot.prototype.hasRedoAction = function() {
  return this.has$Value(5);
};


/**
 * @return {number} The number of values in the redo_action field.
 */
sketchology.proto.Snapshot.prototype.redoActionCount = function() {
  return this.count$Values(5);
};


/**
 * Clears the values in the redo_action field.
 */
sketchology.proto.Snapshot.prototype.clearRedoAction = function() {
  this.clear$Field(5);
};


/**
 * Gets the value of the element_state_index field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.ElementState} The value.
 */
sketchology.proto.Snapshot.prototype.getElementStateIndex = function(index) {
  return /** @type {?sketchology.proto.ElementState} */ (this.get$Value(6, index));
};


/**
 * Gets the value of the element_state_index field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.ElementState} The value.
 */
sketchology.proto.Snapshot.prototype.getElementStateIndexOrDefault = function(index) {
  return /** @type {!sketchology.proto.ElementState} */ (this.get$ValueOrDefault(6, index));
};


/**
 * Adds a value to the element_state_index field.
 * @param {!sketchology.proto.ElementState} value The value to add.
 */
sketchology.proto.Snapshot.prototype.addElementStateIndex = function(value) {
  this.add$Value(6, value);
};


/**
 * Returns the array of values in the element_state_index field.
 * @return {!Array<!sketchology.proto.ElementState>} The values in the field.
 */
sketchology.proto.Snapshot.prototype.elementStateIndexArray = function() {
  return /** @type {!Array<!sketchology.proto.ElementState>} */ (this.array$Values(6));
};


/**
 * @return {boolean} Whether the element_state_index field has a value.
 */
sketchology.proto.Snapshot.prototype.hasElementStateIndex = function() {
  return this.has$Value(6);
};


/**
 * @return {number} The number of values in the element_state_index field.
 */
sketchology.proto.Snapshot.prototype.elementStateIndexCount = function() {
  return this.count$Values(6);
};


/**
 * Clears the values in the element_state_index field.
 */
sketchology.proto.Snapshot.prototype.clearElementStateIndex = function() {
  this.clear$Field(6);
};


/**
 * Gets the value of the fingerprint field.
 * @return {?string} The value.
 */
sketchology.proto.Snapshot.prototype.getFingerprint = function() {
  return /** @type {?string} */ (this.get$Value(7));
};


/**
 * Gets the value of the fingerprint field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.Snapshot.prototype.getFingerprintOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(7));
};


/**
 * Sets the value of the fingerprint field.
 * @param {string} value The value.
 */
sketchology.proto.Snapshot.prototype.setFingerprint = function(value) {
  this.set$Value(7, value);
};


/**
 * @return {boolean} Whether the fingerprint field has a value.
 */
sketchology.proto.Snapshot.prototype.hasFingerprint = function() {
  return this.has$Value(7);
};


/**
 * @return {number} The number of values in the fingerprint field.
 */
sketchology.proto.Snapshot.prototype.fingerprintCount = function() {
  return this.count$Values(7);
};


/**
 * Clears the values in the fingerprint field.
 */
sketchology.proto.Snapshot.prototype.clearFingerprint = function() {
  this.clear$Field(7);
};



/**
 * Message MutationPacket.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.MutationPacket = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.MutationPacket, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.MutationPacket.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.MutationPacket} The cloned message.
 * @override
 */
sketchology.proto.MutationPacket.prototype.clone;


/**
 * Gets the value of the mutation field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.StorageAction} The value.
 */
sketchology.proto.MutationPacket.prototype.getMutation = function(index) {
  return /** @type {?sketchology.proto.StorageAction} */ (this.get$Value(1, index));
};


/**
 * Gets the value of the mutation field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.StorageAction} The value.
 */
sketchology.proto.MutationPacket.prototype.getMutationOrDefault = function(index) {
  return /** @type {!sketchology.proto.StorageAction} */ (this.get$ValueOrDefault(1, index));
};


/**
 * Adds a value to the mutation field.
 * @param {!sketchology.proto.StorageAction} value The value to add.
 */
sketchology.proto.MutationPacket.prototype.addMutation = function(value) {
  this.add$Value(1, value);
};


/**
 * Returns the array of values in the mutation field.
 * @return {!Array<!sketchology.proto.StorageAction>} The values in the field.
 */
sketchology.proto.MutationPacket.prototype.mutationArray = function() {
  return /** @type {!Array<!sketchology.proto.StorageAction>} */ (this.array$Values(1));
};


/**
 * @return {boolean} Whether the mutation field has a value.
 */
sketchology.proto.MutationPacket.prototype.hasMutation = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the mutation field.
 */
sketchology.proto.MutationPacket.prototype.mutationCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the mutation field.
 */
sketchology.proto.MutationPacket.prototype.clearMutation = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the element field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.ElementBundle} The value.
 */
sketchology.proto.MutationPacket.prototype.getElement = function(index) {
  return /** @type {?sketchology.proto.ElementBundle} */ (this.get$Value(2, index));
};


/**
 * Gets the value of the element field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.ElementBundle} The value.
 */
sketchology.proto.MutationPacket.prototype.getElementOrDefault = function(index) {
  return /** @type {!sketchology.proto.ElementBundle} */ (this.get$ValueOrDefault(2, index));
};


/**
 * Adds a value to the element field.
 * @param {!sketchology.proto.ElementBundle} value The value to add.
 */
sketchology.proto.MutationPacket.prototype.addElement = function(value) {
  this.add$Value(2, value);
};


/**
 * Returns the array of values in the element field.
 * @return {!Array<!sketchology.proto.ElementBundle>} The values in the field.
 */
sketchology.proto.MutationPacket.prototype.elementArray = function() {
  return /** @type {!Array<!sketchology.proto.ElementBundle>} */ (this.array$Values(2));
};


/**
 * @return {boolean} Whether the element field has a value.
 */
sketchology.proto.MutationPacket.prototype.hasElement = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the element field.
 */
sketchology.proto.MutationPacket.prototype.elementCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the element field.
 */
sketchology.proto.MutationPacket.prototype.clearElement = function() {
  this.clear$Field(2);
};


/** @override */
sketchology.proto.Color.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.Color.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'Color',
        fullName: 'sketchology.proto.Color'
      },
      1: {
        name: 'argb',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      }
    };
    sketchology.proto.Color.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.Color, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.Color.getDescriptor =
    sketchology.proto.Color.prototype.getDescriptor;


/** @override */
sketchology.proto.BackgroundColor.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.BackgroundColor.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'BackgroundColor',
        fullName: 'sketchology.proto.BackgroundColor'
      },
      1: {
        name: 'rgba',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      }
    };
    sketchology.proto.BackgroundColor.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.BackgroundColor, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.BackgroundColor.getDescriptor =
    sketchology.proto.BackgroundColor.prototype.getDescriptor;


/** @override */
sketchology.proto.PageProperties.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.PageProperties.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'PageProperties',
        fullName: 'sketchology.proto.PageProperties'
      },
      1: {
        name: 'background_color',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Color
      },
      2: {
        name: 'background_image',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.BackgroundImageInfo
      },
      3: {
        name: 'bounds',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Rect
      },
      4: {
        name: 'border',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Border
      }
    };
    sketchology.proto.PageProperties.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.PageProperties, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.PageProperties.getDescriptor =
    sketchology.proto.PageProperties.prototype.getDescriptor;


/** @override */
sketchology.proto.AddAction.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.AddAction.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'AddAction',
        fullName: 'sketchology.proto.AddAction'
      },
      1: {
        name: 'uuid',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      2: {
        name: 'below_element_with_uuid',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      }
    };
    sketchology.proto.AddAction.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.AddAction, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.AddAction.getDescriptor =
    sketchology.proto.AddAction.prototype.getDescriptor;


/** @override */
sketchology.proto.RemoveAction.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.RemoveAction.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'RemoveAction',
        fullName: 'sketchology.proto.RemoveAction'
      },
      1: {
        name: 'uuid',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      2: {
        name: 'was_below_uuid',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      }
    };
    sketchology.proto.RemoveAction.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.RemoveAction, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.RemoveAction.getDescriptor =
    sketchology.proto.RemoveAction.prototype.getDescriptor;


/** @override */
sketchology.proto.ClearAction.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.ClearAction.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ClearAction',
        fullName: 'sketchology.proto.ClearAction'
      },
      1: {
        name: 'uuid',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      }
    };
    sketchology.proto.ClearAction.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.ClearAction, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.ClearAction.getDescriptor =
    sketchology.proto.ClearAction.prototype.getDescriptor;


/** @override */
sketchology.proto.ReplaceAction.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.ReplaceAction.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ReplaceAction',
        fullName: 'sketchology.proto.ReplaceAction'
      },
      1: {
        name: 'uuid_add',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      2: {
        name: 'below_element_with_uuid',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      3: {
        name: 'uuid_remove',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      4: {
        name: 'was_below_uuid',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      }
    };
    sketchology.proto.ReplaceAction.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.ReplaceAction, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.ReplaceAction.getDescriptor =
    sketchology.proto.ReplaceAction.prototype.getDescriptor;


/** @override */
sketchology.proto.SetTransformAction.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.SetTransformAction.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'SetTransformAction',
        fullName: 'sketchology.proto.SetTransformAction'
      },
      1: {
        name: 'uuid',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      2: {
        name: 'from_transform',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.AffineTransform
      },
      3: {
        name: 'to_transform',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.AffineTransform
      }
    };
    sketchology.proto.SetTransformAction.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.SetTransformAction, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.SetTransformAction.getDescriptor =
    sketchology.proto.SetTransformAction.prototype.getDescriptor;


/** @override */
sketchology.proto.SetPageBoundsAction.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.SetPageBoundsAction.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'SetPageBoundsAction',
        fullName: 'sketchology.proto.SetPageBoundsAction'
      },
      1: {
        name: 'old_bounds',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Rect
      },
      2: {
        name: 'new_bounds',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Rect
      }
    };
    sketchology.proto.SetPageBoundsAction.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.SetPageBoundsAction, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.SetPageBoundsAction.getDescriptor =
    sketchology.proto.SetPageBoundsAction.prototype.getDescriptor;


/** @override */
sketchology.proto.StorageAction.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.StorageAction.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'StorageAction',
        fullName: 'sketchology.proto.StorageAction'
      },
      1: {
        name: 'add_action',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.AddAction
      },
      2: {
        name: 'remove_action',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.RemoveAction
      },
      3: {
        name: 'clear_action',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ClearAction
      },
      4: {
        name: 'replace_action',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ReplaceAction
      },
      5: {
        name: 'set_transform_action',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.SetTransformAction
      },
      6: {
        name: 'set_page_bounds_action',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.SetPageBoundsAction
      }
    };
    sketchology.proto.StorageAction.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.StorageAction, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.StorageAction.getDescriptor =
    sketchology.proto.StorageAction.prototype.getDescriptor;


/** @override */
sketchology.proto.Snapshot.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.Snapshot.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'Snapshot',
        fullName: 'sketchology.proto.Snapshot'
      },
      1: {
        name: 'page_properties',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.PageProperties
      },
      2: {
        name: 'element',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ElementBundle
      },
      3: {
        name: 'dead_element',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ElementBundle
      },
      4: {
        name: 'undo_action',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.StorageAction
      },
      5: {
        name: 'redo_action',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.StorageAction
      },
      6: {
        name: 'element_state_index',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: sketchology.proto.ElementState.ALIVE,
        type: sketchology.proto.ElementState
      },
      7: {
        name: 'fingerprint',
        fieldType: goog.proto2.Message.FieldType.UINT64,
        type: String
      }
    };
    sketchology.proto.Snapshot.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.Snapshot, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.Snapshot.getDescriptor =
    sketchology.proto.Snapshot.prototype.getDescriptor;


/** @override */
sketchology.proto.MutationPacket.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.MutationPacket.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'MutationPacket',
        fullName: 'sketchology.proto.MutationPacket'
      },
      1: {
        name: 'mutation',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.StorageAction
      },
      2: {
        name: 'element',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ElementBundle
      }
    };
    sketchology.proto.MutationPacket.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.MutationPacket, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.MutationPacket.getDescriptor =
    sketchology.proto.MutationPacket.prototype.getDescriptor;
