#ifndef VISUAL_XGL_H
#define VISUAL_XGL_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

// Xgl - GTK platform-specific GL and windowing code

#include "vector.h"

#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>
#include <gtkgl/gtkglarea.h>

#include <map>
#include <string>
#include <queue>
#include <vector>
#include <utility>

#include "platlinux.h"
#include "glcontext.h"
#include <GL/gl.h>
#include <GL/glu.h>

namespace visual {

struct xglFont : glFont 
{
 public:
	//from glFont
	virtual double getWidth(const char *text);
	virtual double ascent();
	virtual double descent();
	virtual void draw(const char *text);
	virtual void release();
  
	//used by xglContext
	xglFont(struct xglContext& cx, 
		const char *name, 
		double size);
	virtual ~xglFont();
	void addref() {refcount++;};
  
 private:
	struct xglContext& cx;
	int listBase;
	GdkFont *font;
	int refcount;
};

struct xglContext : glContext 
{
 public:
	void lockMouse();
	void unlockMouse();
	void showMouse() { printf("xgl.h: Someone should write showMouse!\n"); }
	void hideMouse() { printf("xgl.h: Someone should write hideMouse!\n"); }
	int  getMouseButtons();
	int  getMouseButtonsChanged();
	vector  getMouseDelta();
	vector  getMousePos();
	std::string getKeys();
	int getShiftKey();
	int getAltKey();
	int getCtrlKey();

	xglContext();
	~xglContext();

	bool initWindow( const char* title, int x, int y, int width, int height, int flags );
	bool changeWindow( const char* title, int x, int y, int width, int height, int flags );
	bool isOpen();
	void cleanup();
  
	void makeCurrent();
	void makeNotCurrent();
	void swapBuffers();

	vector origin();
	vector corner();
	int width();
	int height();

	inline std::string lastError() { return error_message; }
    
	glFont* getFont(const char* description, double size);

 private:
	GtkWidget* window;
	GtkWidget* area;
	int wwidth, wheight;
	std::string error_message;

	int buttonState, buttonsChanged;
    int Kshift, Kalt, Kctrl; //true if down when mouse event happens
	vector mousePos, oldMousePos;
	bool mouseLocked;
	std::queue<std::string> keys;

	// Event callback handlers.
	static void realize_cb( GtkWidget* widget, gpointer data);
	static gint configure_cb( GtkWidget* widget, GdkEventConfigure* event, gpointer data);
    static gint motion_notify_cb( GtkWidget* widget, GdkEventMotion* event, gpointer data);
    static gint delete_cb( GtkWidget* widget, GdkEvent* event, gpointer data);
    static gint button_press_cb( GtkWidget* widget, GdkEventButton* event, gpointer data);
    static gint button_release_cb( GtkWidget* widget, GdkEventButton* event, gpointer data);
    static gint key_press_cb( GtkWidget* widget, GdkEventKey* key, gpointer data); 
    static gint key_release_cb( GtkWidget* widget, GdkEventKey* key, gpointer data);
};

} // !namespace std

#endif // !defined VISUAL_XGL_H
