#ifndef VISUAL_ROTATE_H
#define VISUAL_ROTATE_H

#include <boost/python/tuple.hpp>
#include <boost/python/dict.hpp>
#include <boost/python/extract.hpp>
#include <boost/python/raw_function.hpp>

namespace visual {

/* Unfortunately the signatures of the functions primitive.rotate( "angle", "axis")
 * and primitive.rotate( "angle", "origin") are identical to Boost.Python.  To 
 * differentiate them, I am using this raw function to interpret the arguments.
 * Ick.
 */
template <typename Prim>
boost::python::object
py_rotate( boost::python::tuple args, boost::python::dict kwargs)
{
	using boost::python::extract;
	
	Prim* This = extract<Prim*>( args[0]);
	
	if (!kwargs.has_key("angle")) {
		// This exception is more useful than the keyerror exception below.
		throw std::invalid_argument( 
			"primitive.rotate(): angle of rotation must be specified.");
	}
	
	double angle = extract<double>(kwargs["angle"]);
	
	// The rotation axis, which defaults to the body axis.
	vector r_axis;
	if (kwargs.has_key("axis"))
		r_axis = vector(kwargs["axis"]);
	else
		r_axis = This->get_axis();
	
	// The rotation origin, which defaults to the body position.
	vector origin;
	if (kwargs.has_key("origin"))
		origin = vector(kwargs["origin"]);
	else
		origin = This->get_pos();
	
	This->py_rotate( angle, r_axis, origin);
	return boost::python::object();
}
	
} // !namespace visual

#endif // !defined VISUAL_ROTATE_H
