# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CertificateDescription(Model):
    """Describes the certificate details.

    All required parameters must be populated in order to send to Azure.

    :param thumbprint: Required. Thumbprint of the primary certificate.
    :type thumbprint: str
    :param thumbprint_secondary: Thumbprint of the secondary certificate.
    :type thumbprint_secondary: str
    :param x509_store_name: The local certificate store location. Possible
     values include: 'AddressBook', 'AuthRoot', 'CertificateAuthority',
     'Disallowed', 'My', 'Root', 'TrustedPeople', 'TrustedPublisher'
    :type x509_store_name: str or ~azure.mgmt.servicefabric.models.enum
    """

    _validation = {
        'thumbprint': {'required': True},
    }

    _attribute_map = {
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'thumbprint_secondary': {'key': 'thumbprintSecondary', 'type': 'str'},
        'x509_store_name': {'key': 'x509StoreName', 'type': 'str'},
    }

    def __init__(self, *, thumbprint: str, thumbprint_secondary: str=None, x509_store_name=None, **kwargs) -> None:
        super(CertificateDescription, self).__init__(**kwargs)
        self.thumbprint = thumbprint
        self.thumbprint_secondary = thumbprint_secondary
        self.x509_store_name = x509_store_name
