# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TargetRestoreInfo(Model):
    """Details about target workload during restore operation.

    :param overwrite_option: Can Overwrite if Target DataBase already exists.
     Possible values include: 'Invalid', 'FailOnConflict', 'Overwrite'
    :type overwrite_option: str or
     ~azure.mgmt.recoveryservicesbackup.models.OverwriteOptions
    :param container_id: Resource Id name of the container in which Target
     DataBase resides
    :type container_id: str
    :param database_name: Database name InstanceName/DataBaseName for SQL or
     System/DbName for SAP Hana
    :type database_name: str
    """

    _attribute_map = {
        'overwrite_option': {'key': 'overwriteOption', 'type': 'str'},
        'container_id': {'key': 'containerId', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TargetRestoreInfo, self).__init__(**kwargs)
        self.overwrite_option = kwargs.get('overwrite_option', None)
        self.container_id = kwargs.get('container_id', None)
        self.database_name = kwargs.get('database_name', None)
