# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CertificateBaseProperties(Model):
    """CertificateBaseProperties.

    :param thumbprint_algorithm: The algorithm of the certificate thumbprint.
     This must match the first portion of the certificate name. Currently
     required to be 'SHA1'.
    :type thumbprint_algorithm: str
    :param thumbprint: The thumbprint of the certificate. This must match the
     thumbprint from the name.
    :type thumbprint: str
    :param format: The format of the certificate - either Pfx or Cer. If
     omitted, the default is Pfx. Possible values include: 'Pfx', 'Cer'
    :type format: str or ~azure.mgmt.batch.models.CertificateFormat
    """

    _attribute_map = {
        'thumbprint_algorithm': {'key': 'thumbprintAlgorithm', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'format': {'key': 'format', 'type': 'CertificateFormat'},
    }

    def __init__(self, thumbprint_algorithm=None, thumbprint=None, format=None):
        super(CertificateBaseProperties, self).__init__()
        self.thumbprint_algorithm = thumbprint_algorithm
        self.thumbprint = thumbprint
        self.format = format
