from Ft.Server.Server.Drivers import LoadDriverModule

def test_escape(tester):

    from Ft.Server.Server.Drivers.Postgres import Escapec

    tester.startGroup("Escape and Split")
    for initial in ['Foo',
                    "Foo'oo",
                    "0123456789" * 1000,
                    "0123'456789" * 1000,
                    "0x001",
                    "0x0A1",
                    "%s"%chr(1),
                    "%s"%chr(0),
                    "\\",
                    "01230x0456789" * 1000,
                    "\n",
                    ]:
        tester.startTest(repr(initial[:10]))

        expected = ""
        for c in initial:
            if ord(c) == 0:
                expected += "\\\\000"
            elif c == '\\':
                expected += '\\\\\\\\'
            elif c == '\'':
                expected += "\\'"
            else:
                expected += c
        result = Escapec.escape(initial)
        tester.compare(expected, result, 'escape')

        original = ""
        for c in initial:
            if ord(c) < 32:
                original += "\\%03o" % ord(c)
            elif c == '\\':
                original += '\\\\'
            else:
                original += c
        result = Escapec.unescape(original)
        tester.compare(initial, result, 'unescape (%s)' % original[:10])
        tester.testDone()
    tester.groupDone()


def Test(tester):
    import test_driver
    import test_ftss_driver

    try:
        driverModule = LoadDriverModule('Postgres')
    except Exception, error:
        tester.warning(str(error))
        return

    test_escape(tester)

    props = {'DbName':test_driver.TEST_DBNAME,
             'Host':None,
             'Port':-1,
             'User':None,
             'Passwd':None}
    test_driver.Test(tester, driverModule, props)

    props['TYPE'] = 'Postgres'
    props = {'Driver':props}
    test_ftss_driver.Test(tester, props)
    return
