import sys

from Ft.Rdf import BNODE_BASE

def make_anonymous(id, anons):
    if id in anons:
        return anons[id]
    anon = u'ANONYMOUS%d' % len(anons)
    anons[id] = anon
    return anon

def change_anonymous(statement, anonymous, anon_ids):
    if statement[0][:len(anonymous)] == anonymous:
        statement[0] = make_anonymous(statement[0], anon_ids)
    if statement[2][:len(anonymous)] == anonymous:
        statement[2] = make_anonymous(statement[2], anon_ids)
    return statement

def make_tuple(statements, source_uri):
    anons = {}
    anonymous = BNODE_BASE
    result = []
    for statement in statements:
        stmt = [statement.subject,
                statement.predicate,
                statement.object,
                statement.uri,
                statement.scope,
                ]
        change_anonymous(stmt, anonymous, anons)
        #change_anonymous(stmt, 'anonymous:', anons)
        result.append(tuple(stmt))
    result.sort()
    return result

def convert_tuple(statements):
    statements = [ tuple(map(unicode, stmt)) for stmt in statements ]
    statements.sort()
    return statements

def compare_tuple(expected, actual):
    expected = [ tuple(map(unicode, stmt)) for stmt in expected ]
    actual = [ tuple(map(unicode, stmt)) for stmt in actual ]

    #import pprint
    #print "Expected:"
    #pprint.pprint(expected)
    #print "Compared:"
    #pprint.pprint(actual)
    for stmt in expected:
        try:
            actual.remove(stmt)
        except ValueError:
            print "statement missing from actual: (failed comparison)", stmt
            return 1

    # Zero means equal
    return len(actual)

def print_tuple(statements):
    max_subj = len('subject')
    max_pred = len('predicate')
    max_obj = len('object')
    for statement in statements:
        subj = len(statement[0])
        pred = len(statement[1])
        obj = len(statement[2])
        if subj > max_subj: max_subj = subj
        if pred > max_pred: max_pred = pred
        if obj > max_obj: max_obj = obj

    print '%-*s | %-*s | %-*s' % (max_subj, 'subject',
                                  max_pred, 'predicate',
                                  max_obj, 'object',
                                  )
    print '-'*(max_subj + max_pred + max_obj + 6)

    for statement in statements:
        print '%-*s | %-*s | %-*s' % (max_subj, str(statement[0]),
                                      max_pred, str(statement[1]),
                                      max_obj, str(statement[2]),
                                      )
    return
