########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Xslt/RawFile.py,v 1.4 2005/04/06 23:05:46 jkloth Exp $
"""
XSLT extension elements and functions supporting the 4SS RawFile API

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ns import SCORE_NS
import FtssXsltBase
from Ft.Xml.XPath import Conversions
from Ft.Xml.Xslt import XsltElement, ContentInfo, AttributeInfo



def GetImt(context, path=None):
    """
    Get the IMT of a resource
    """
    path = Conversions.StringValue(path)
    return FtssXsltBase.FetchBaseObject(context.processor, path).getImt()


class SetImtElement(XsltElement):
    """
    Change the IMT of a resource
    """
    content = ContentInfo.Empty

    legalAttrs = {
        'path' : AttributeInfo.UriReferenceAvt(
            description=('The path of the resource to change the IMT of.'
                         ' Defaults to current.')),
        'imt' : AttributeInfo.StringAvt(
            required=1, description='The new IMT'),
        }

    def instantiate(self, context, processor):
        context.setProcessState(self)

        # This may return None (the 'default' from AttributeInfo)
        path = self._path.evaluate(context)
        imt = self._imt.evaluate(context)

        obj = FtssXsltBase.FetchBaseObject(processor, path)
        obj.setImt(imt)

        return



ExtFunctions = {
    (SCORE_NS, 'get-imt'): GetImt,
}

ExtElements = {
    (SCORE_NS, 'set-imt'): SetImtElement,
}
