############################################################################
#
# File Name: 		Collection.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Collection.py.html
#

"""
Base class for all collections
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods import Database
from Ft.Ods.StorageManager.Adapters import Constants

class Collection:


    def __init__(self,db,cid):


        self.__dict__['_cid'] = cid

        # See if we are in a transaction
        self.__dict__['_db'] = db
        if self._db:
            self.__dict__['_tx'] = self._db.current()
        else:
            self.__dict__['_tx'] = None

        if self._tx:
            if cid:
                self._tx._4ods_registerModifiedPersistentObject(self)
            else:
                self._tx._4ods_registerNewPersistentObject(self)
        self.__dict__['_deleted'] = 0

    def delete(self,recurse=0):
        if self._tx:
            self._tx._4ods_deletePersistentObject(self)
        self.__dict__['_deleted'] = 1

    def _4ods_getId(self):
        return self._cid

    def _4ods_setCid(self, cid):
        self.__dict__['_cid'] = cid


    _extents = ()
    _localExtents = ()



