from Xslt import test_harness

simple_sheet_str = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match='/'>
    <docelem>
    <xsl:apply-templates/>
    </docelem>
  </xsl:template>
  <xsl:template match='text()'/>
  <xsl:template match='item'>
    <xsl:value-of select='.'/>
  </xsl:template>
</xsl:stylesheet>
"""

select_sheet_str = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match='/'>
    <docelem>
      <xsl:apply-templates select='data/item[@in]'/>
    </docelem>
  </xsl:template>
  <xsl:template match='text()'/>
  <xsl:template match='item'>
    <xsl:value-of select='.'/>
  </xsl:template>
</xsl:stylesheet>
"""

sort_sheet_str = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match='/'>
    <docelem>
    <xsl:apply-templates/>
    </docelem>
  </xsl:template>
  <xsl:template match='data'>
    <xsl:apply-templates>
      <xsl:sort select='.'/>
    </xsl:apply-templates>
  </xsl:template>
  <xsl:template match='text()'/>
  <xsl:template match='item'>
    <xsl:value-of select='.'/>
  </xsl:template>
</xsl:stylesheet>
"""

param_sheet_str = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match='/'>
    <docelem>
    <xsl:apply-templates/>
    </docelem>
  </xsl:template>
  <xsl:template match='data'>
    <xsl:apply-templates>
      <xsl:with-param name='foo' select='1'/>
    </xsl:apply-templates>
  </xsl:template>
  <xsl:template match='text()'/>
  <xsl:template match='item'>
    <xsl:param name='foo'/>
    <xsl:value-of select='concat($foo,.)'/>
  </xsl:template>
</xsl:stylesheet>
"""

sort_param_sheet_str = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match='/'>
    <docelem>
    <xsl:apply-templates/>
    </docelem>
  </xsl:template>
  <xsl:template match='data'>
    <xsl:apply-templates>
      <xsl:sort select='.'/>
      <xsl:with-param name='foo' select='1'/>
    </xsl:apply-templates>
  </xsl:template>
  <xsl:template match='text()'/>
  <xsl:template match='item'>
    <xsl:param name='foo'/>
    <xsl:value-of select='concat($foo,.)'/>
  </xsl:template>
</xsl:stylesheet>
"""


select_sort_sheet_str = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match='/'>
    <docelem>
    <xsl:apply-templates/>
    </docelem>
  </xsl:template>
  <xsl:template match='data'>
    <xsl:apply-templates select='item[@in]'>
      <xsl:sort select='.'/>
    </xsl:apply-templates>
  </xsl:template>
  <xsl:template match='text()'/>
  <xsl:template match='item'>
    <xsl:value-of select='.'/>
  </xsl:template>
</xsl:stylesheet>
"""

select_param_sheet_str = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match='/'>
    <docelem>
    <xsl:apply-templates/>
    </docelem>
  </xsl:template>
  <xsl:template match='data'>
    <xsl:apply-templates select='item[@in]'>
      <xsl:with-param name='foo' select='1'/>
    </xsl:apply-templates>
  </xsl:template>
  <xsl:template match='text()'/>
  <xsl:template match='item'>
    <xsl:param name='foo'/>
    <xsl:value-of select='concat($foo,.)'/>
  </xsl:template>
</xsl:stylesheet>
"""

select_sort_param_sheet_str = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match='/'>
    <docelem>
    <xsl:apply-templates/>
    </docelem>
  </xsl:template>
  <xsl:template match='data'>
    <xsl:apply-templates select='item[@in]'>
      <xsl:sort select='.'/>
      <xsl:with-param name='foo' select='1'/>
    </xsl:apply-templates>
  </xsl:template>
  <xsl:template match='text()'/>
  <xsl:template match='item'>
    <xsl:param name='foo'/>
    <xsl:value-of select='concat($foo,.)'/>
  </xsl:template>
</xsl:stylesheet>
"""



source_str_start = """<?xml version = "1.0"?>
<data>
"""
source_str_middle = """ <item>b</item>
 <item in='1'>a</item>
 <item>d</item>
 <item in='1'>c</item>
"""
source_str_end = """</data>
"""

MULTIPLIER = 50

source_str = source_str_start + source_str_middle*MULTIPLIER + source_str_end


simple_expected = """<?xml version='1.0' encoding='UTF-8'?>\n<docelem>"""+"""badc"""*MULTIPLIER + "</docelem>"
select_expected = """<?xml version='1.0' encoding='UTF-8'?>\n<docelem>"""+"""ac"""*MULTIPLIER+"</docelem>"
sort_expected = """<?xml version='1.0' encoding='UTF-8'?>\n<docelem>"""+"""a"""*MULTIPLIER + """b"""*MULTIPLIER + """c"""*MULTIPLIER + """d"""*MULTIPLIER+"</docelem>"
param_expected = """<?xml version='1.0' encoding='UTF-8'?>\n<docelem>"""+"""1b1a1d1c"""*MULTIPLIER+"</docelem>"
sort_param_expected = """<?xml version='1.0' encoding='UTF-8'?>\n<docelem>"""+"""1a"""*MULTIPLIER + """1b"""*MULTIPLIER + """1c"""*MULTIPLIER + """1d"""*MULTIPLIER+"</docelem>"
select_sort_expected = """<?xml version='1.0' encoding='UTF-8'?>\n<docelem>"""+"""a"""*MULTIPLIER + """c"""*MULTIPLIER+"</docelem>"
select_param_expected = """<?xml version='1.0' encoding='UTF-8'?>\n<docelem>"""+"""1a1c"""*MULTIPLIER+"</docelem>"
select_sort_param_expected = """<?xml version='1.0' encoding='UTF-8'?>\n<docelem>"""+"""1a"""*MULTIPLIER + """1c"""*MULTIPLIER+"</docelem>"

tests = [('Simple',simple_sheet_str,simple_expected),
         ('Select',select_sheet_str,select_expected),
         ('Sort',sort_sheet_str,sort_expected),
         ('Param',param_sheet_str,param_expected),
         ('Sort Param',sort_param_sheet_str,sort_param_expected),
         ('Select Sort',select_sort_sheet_str,select_sort_expected),
         ('Select Param',select_param_sheet_str,select_param_expected),
         ('Select Sort Param',select_sort_param_sheet_str,select_sort_param_expected),
         ]
         

def Test(tester):
    for (name, xsltSrc, expected) in tests:
        tester.startGroup(name)

        source = test_harness.FileInfo(string=source_str)
        sty = test_harness.FileInfo(string=xsltSrc)
        xtest = test_harness.XsltTester(source,
                                        [sty],
                                        expected,
                                        )
        xtest.test(tester)
        tester.groupDone()
    return
