import os, string

def Test(tester):
    # Convert file path to a relative uri
    path = os.path.dirname(os.path.abspath(__file__))[len(os.getcwd())+1:]
    path = string.replace(path, os.sep, '/')
    
    tester.startTest('Creating test environment')
    from Ft import XPointer
    from Ft.Lib import pDomlette
    r = pDomlette.PyExpatReader()
    doc = r.fromUri('%s/addrbook.xml' % path)
    ADDRBOOK = doc.documentElement
    elementType = lambda n, nt=pDomlette.Node.ELEMENT_NODE: n.nodeType == nt
    ENTRIES = filter(elementType, ADDRBOOK.childNodes)
    PA = ENTRIES[0]
    children = filter(elementType, PA.childNodes)
    PA_NAME = children[0]
    PA_ADDR = children[1]
    PA_WORK = children[2]
    PA_FAX = children[3]
    PA_PAGER = children[4]
    PA_EMAIL = children[5]
    EN = ENTRIES[1]
    children = filter(elementType, EN.childNodes)
    EN_NAME = children[0]
    EN_ADDR = children[1]
    EN_WORK = children[2]
    EN_FAX = children[3]
    EN_PAGER = children[4]
    EN_EMAIL = children[5]
    
    VZ = ENTRIES[2]

    
    tester.testDone()

    tester.startTest('Testing convenience functions')

    # Just one, it can be to confusing to compare much else
    # because the documents are different
    uri = '%s/addrbook.xml#/1' % path
    result = XPointer.SelectUri(uri)
    tester.compare(ADDRBOOK.nodeName, result.nodeName, 'SelectUri(%s)' % uri)
    
    frag = 'pa/2'
    result = XPointer.SelectNode(doc, frag)
    tester.compare(PA_ADDR, result, 'SelectNode, frag=%s' % frag)

    frag = 'xpointer(//ENTRY[@ID="en"]/EMAIL)'
    result = XPointer.SelectNode(doc, frag)
    tester.compare(EN_EMAIL, result, 'SelectNode, frag=%s' % frag)

    tester.testDone()

    tester.startTest('Testing remote lookup')
    nss = {'xsl':'http://www.w3.org/1999/XSL/Transform'}
    uri = "http://xslt.fourthought.com/api.xslt#xpointer(//xsl:template[@match='/'])"
    result = XPointer.SelectUri(uri, nss=nss)
    tester.compare('template', result.localName, 'Wrong localName')
    tester.compare('/', result.attributes[('', 'match')].value, 'Wrong attribute')
    tester.testDone()
    return
