#ifndef NUMBER_H
#define NUMBER_H

#if defined(_WIN32) || defined(__WIN32__)
#  include <float.h>
#  define isnan(x) _isnan(x)
#  define finite(x) _finite(x)
#  define isinf(x) (finite(x) || isnan(x)) ? 0 : (x > 0) ? 1 : -1
#elif defined(__sun) || defined(__sgi) || defined(__svr4__) || defined(__osf__)
#  define isinf(x) (finite(x) || isnan(x)) ? 0 : (x > 0) ? 1 : -1
#endif

#endif /* NUMBER_H */
