<?php
// Call Image_TextTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "Image_TextTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

require_once 'Image/Text.php';
require_once dirname(__FILE__) . '/imageisthesame.php';

/**
 * Test class for Image_Text.
 * Generated by PHPUnit_Util_Skeleton on 2007-04-15 at 15:14:46.
 */
class Image_TextTest extends PHPUnit_Framework_TestCase {
    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite  = new PHPUnit_Framework_TestSuite("Image_TextTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {
        $this->dir = dirname(__FILE__) . '/testimages/';
    }

    protected function initInstance($text)
    {
        $i = new Image_Text($text);
        $i->set(array(
            'font_path' => dirname(__FILE__) . '/',
            'font_file' => 'Vera.ttf',
            'font_size' => 12,
            'canvas'    => array('width'=> 200,'height'=> 100),
            'width'     => 200,
            'height'    => 200,
            'color'     => array('#FFFFFF')
        ));
        return $i;
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown() {
    }

    /**
     *
     */
    public function testConstruct() {
return;
        $i = $this->initInstance('test');
        $this->assertType('Image_Text', $i);
        $this->assertTrue($i->init());
        $this->assertTrue($i->render());
        $this->assertTrue(imageisthesame(
            $this->dir . 'test-construct.png',
            $i->getImg()
        ));

        $i = $this->initInstance('text');
        $this->assertType('Image_Text', $i);
        $this->assertTrue($i->init());
        $this->assertTrue($i->render());
        $this->assertFalse(imageisthesame(
            $this->dir . 'test-construct.png',
            $i->getImg()
        ));
    }

    public function testBackgroundColor() {
        //default background is black
        $i = $this->initInstance('test');
        $this->assertType('Image_Text', $i);
        $this->assertTrue($i->init());
        $this->assertTrue($i->render());
        $this->assertTrue(imageisthesame(
            $this->dir . 'test-construct.png',
            $i->getImg()
        ));

        //red background
        $i = $this->initInstance('text');
        $this->assertType('Image_Text', $i);
        $i->set(array('background_color' => '#FF0000'));
        $this->assertTrue($i->init());
        $this->assertTrue($i->render());
        $this->assertTrue(imageisthesame(
            $this->dir . 'test-background-red.png',
            $i->getImg()
        ));

        //transparent background
        $i = $this->initInstance('text');
        $this->assertType('Image_Text', $i);
        $i->set(array('background_color' => null));
        $this->assertTrue($i->init());
        $this->assertTrue($i->render());
        $this->assertTrue(imageisthesame(
            $this->dir . 'test-background-transparent.png',
            $i->getImg()
        ));
    }

    /**
     * @todo Implement testSet().
     */
    public function testSet() {
        // Remove the following line when you implement this test.
        $this->markTestIncomplete(
          "This test has not been implemented yet."
        );
    }

    /**
     * @todo Implement testSetColors().
     */
    public function testSetColors() {
        // Remove the following line when you implement this test.
        $this->markTestIncomplete(
          "This test has not been implemented yet."
        );
    }

    /**
     * @todo Implement testSetColor().
     */
    public function testSetColor() {
        // Remove the following line when you implement this test.
        $this->markTestIncomplete(
          "This test has not been implemented yet."
        );
    }

    /**
     * @todo Implement testInit().
     */
    public function testInit() {
        // Remove the following line when you implement this test.
        $this->markTestIncomplete(
          "This test has not been implemented yet."
        );
    }

    /**
     * @todo Implement testAutoMeasurize().
     */
    public function testAutoMeasurize() {
        // Remove the following line when you implement this test.
        $this->markTestIncomplete(
          "This test has not been implemented yet."
        );
    }

    /**
     * @todo Implement testMeasurize().
     */
    public function testMeasurize() {
        // Remove the following line when you implement this test.
        $this->markTestIncomplete(
          "This test has not been implemented yet."
        );
    }

    /**
     * @todo Implement testRender().
     */
    public function testRender() {
        // Remove the following line when you implement this test.
        $this->markTestIncomplete(
          "This test has not been implemented yet."
        );
    }

    /**
     * @todo Implement testGetImg().
     */
    public function testGetImg() {
        // Remove the following line when you implement this test.
        $this->markTestIncomplete(
          "This test has not been implemented yet."
        );
    }

    /**
     * @todo Implement testDisplay().
     */
    public function testDisplay() {
        // Remove the following line when you implement this test.
        $this->markTestIncomplete(
          "This test has not been implemented yet."
        );
    }

    /**
     * @todo Implement testSave().
     */
    public function testSave() {
        // Remove the following line when you implement this test.
        $this->markTestIncomplete(
          "This test has not been implemented yet."
        );
    }

    /**
     * @todo Implement test_getOffset().
     */
    public function test_getOffset() {
        // Remove the following line when you implement this test.
        $this->markTestIncomplete(
          "This test has not been implemented yet."
        );
    }

    /**
     *
     */
    public function test_convertString2RGB() {
        $this->assertEquals(
            array('r'=> 255,'g'=> 255,'b'=> 255,'a'=> 0),
            Image_Text::_convertString2RGB('#FFFFFF')
        );
        $this->assertEquals(
            array('r'=> 255,'g'=> 255,'b'=> 255,'a'=> 0),
            Image_Text::_convertString2RGB('#00FFFFFF')
        );
        $this->assertEquals(
            array('r'=> 0,'g'=> 0,'b'=> 0,'a'=> 0),
            Image_Text::_convertString2RGB('#000000')
        );
        $this->assertEquals(
            array('r'=> 0,'g'=> 0,'b'=> 0,'a'=> 255),
            Image_Text::_convertString2RGB('#FF000000')
        );
    }

    /**
     * @todo Implement test_processText().
     */
    public function test_processText() {
        // Remove the following line when you implement this test.
        $this->markTestIncomplete(
          "This test has not been implemented yet."
        );
    }
}

// Call Image_TextTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "Image_TextTest::main") {
    Image_TextTest::main();
}
?>
