/*-------------------------------------------------------------------------
 * Copyright (c) 2000 Kenneth W. Sodemann (stufflehead@bigfoot.com)
 *-------------------------------------------------------------------------
 * ini_defs
 *
 * Synopsis:
 *   Defines used with the INI files
 *
 * $Id: ini_defs.c,v 1.1 2000/10/15 15:37:27 stuffle Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330 
 * Boston, MA  02111-1307  USA
 *
 *-------------------------------------------------------------------------
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "ini_defs.h"

#define  BASIC_CONF         "/%s/%s/%s"
#define  CONF_WITH_INT_DEF  "/%s/%s/%s=%d"
#define  CONF_WITH_STR_DEF  "/%s/%s/%s=%s"

gint
ini_get_int (const gchar *ini_file,
             const gchar *section,
             const gchar *label,
             gint         def_val)
{
   GString  *str;
   gint      rtn_val;

   str = g_string_new ("");
   g_string_sprintf (str, CONF_WITH_INT_DEF, ini_file, 
                     section, label, def_val);

   rtn_val = gnome_config_get_int (str->str);
   g_string_free (str, TRUE);

   return rtn_val;
}


void
ini_set_int (const gchar *ini_file,
             const gchar *section,
             const gchar *label,
             gint         value)
{
   GString  *str;

   str = g_string_new ("");
   g_string_sprintf (str, BASIC_CONF, ini_file, section, label);
   gnome_config_set_int (str->str, value);
   g_string_free (str, TRUE);

   return;
}
