# -*- ruby -*-
#
# Using an internal stack.
#

require 'xtemplate'

data = {
  'members' => [
    {"name" => "name1", "age" => 20},
    {"name" => "name2", "age" => 23},
    {"name" => "name3", "age" => 30},
  ],
  'operators' => [
    {"name" => "op1", "age" => 28},
    {"name" => "op2", "age" => 32},
    {"name" => "op3", "age" => 24},
  ],
}

text = <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<members xmlns:xt="http://xtemplate.sourceforge.net/xtemplate">
  <member xt:id="/members{push(stack1)}|/operators{pop(stack1);sort(age)}/name">
  </member>

  <xt:value-of id="/members{push(stack2)}" />
  <xt:value-of id="/members{push(stack2)}" />
  <member xt:id="/operators{pop_all(stack2)}/name">
  </member>

  <xt:value-of id="/members{push(stack3)}" />
  <xt:value-of id="/members{clear_stack(stack3)}" />
  <member xt:id="/operators{pop_all(stack3)}/name">
  </member>
</members>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
