/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax2;

import com.jclark.xsl.sax.CommentHandler;
import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax2.OutputContentHandler;
import com.jclark.xsl.sax2.RawCharactersHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class HTMLOutputHandler
implements OutputContentHandler,
CommentHandler,
RawCharactersHandler {
    private Writer writer;
    private static final int DEFAULT_BUF_LENGTH = 4096;
    private char[] buf = new char[4096];
    private int bufUsed = 0;
    private boolean inCdata = false;
    private boolean inPcdataChunk = true;
    private boolean inBlock = false;
    private final String lineSeparator = System.getProperty("line.separator");
    private boolean indent = true;
    private char maxRepresentableChar = (char)65535;
    private boolean keepOpen;
    private String encoding;
    private String doctypeSystem;
    private String doctypePublic;
    private static final int NORMAL_CONTENT = 0;
    private static final int EMPTY_CONTENT = 1;
    private static final int CDATA_CONTENT = 2;
    private static final int CONTENT_TYPE = 3;
    private static final int BLOCK_ELEMENT = 4;
    private static final int HEAD_ELEMENT = 8;
    private static final int PCDATA_ELEMENT = 16;
    private static final String[] emptyElements;
    private static final String[] cdataElements;
    private static final String[] blockElements;
    private static final String[] pcdataElements;
    private static final String[] booleanAttributes;
    private static final String[] charEntities;
    private static String[][] charMap;
    private static Hashtable elementTypeTable;
    private static Hashtable booleanAttributesTable;

    public HTMLOutputHandler() {
    }

    public HTMLOutputHandler(Writer writer) {
        this.writer = writer;
    }

    public ContentHandler init(Destination dest, Properties props) throws IOException {
        String mediaType = props.getProperty("media-type");
        if (mediaType == null) {
            mediaType = "text/html";
        }
        this.encoding = props.getProperty("encoding");
        if (this.encoding == null) {
            this.writer = dest.getWriter(mediaType, "iso-8859-1");
            this.maxRepresentableChar = (char)127;
        } else {
            this.writer = dest.getWriter(mediaType, this.encoding);
            this.encoding = dest.getEncoding();
            if (this.encoding.equalsIgnoreCase("iso-8859-1")) {
                this.maxRepresentableChar = (char)255;
            } else if (this.encoding.equalsIgnoreCase("us-ascii")) {
                this.maxRepresentableChar = (char)127;
            }
        }
        this.doctypeSystem = props.getProperty("doctype-system");
        this.doctypePublic = props.getProperty("doctype-public");
        this.keepOpen = dest.keepOpen();
        if ("no".equals(props.getProperty("indent"))) {
            this.indent = false;
        }
        return this;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void startDocument() throws SAXException {
    }

    public void characters(char[] ch, int off, int len) throws SAXException {
        if (len == 0) {
            return;
        }
        this.inPcdataChunk = true;
        if (this.inCdata) {
            this.writeUnquoted(new String(ch, off, len));
        } else {
            while (len > 0) {
                char c = ch[off];
                switch (c) {
                    case '\n': {
                        this.write(this.lineSeparator);
                        break;
                    }
                    case '&': {
                        this.write("&amp;");
                        break;
                    }
                    case '<': {
                        this.write("&lt;");
                        break;
                    }
                    case '>': {
                        this.write("&gt;");
                        break;
                    }
                    case '\u00a0': {
                        this.write("&nbsp;");
                        break;
                    }
                    default: {
                        if (c <= this.maxRepresentableChar) {
                            this.write(c);
                            break;
                        }
                        this.write(HTMLOutputHandler.getCharString(c));
                    }
                }
                --len;
                ++off;
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int off, int len) throws SAXException {
        this.characters(ch, off, len);
    }

    public void startPrefixMapping(String prefix, String namespaceURI) {
    }

    public void endPrefixMapping(String prefix) {
    }

    public void skippedEntity(String name) {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        boolean isBlockElement;
        if (this.inCdata) {
            return;
        }
        if (this.doctypeSystem != null || this.doctypePublic != null) {
            char lit;
            this.write("<!DOCTYPE ");
            this.write(qName.equals("HTML") ? "HTML" : "html");
            if (this.doctypePublic != null) {
                this.write(" PUBLIC ");
                lit = this.doctypePublic.indexOf(34) >= 0 ? (char)'\'' : '\"';
                this.write(lit);
                this.write(this.doctypePublic);
                this.write(lit);
            } else {
                this.write(" SYSTEM");
            }
            if (this.doctypeSystem != null) {
                lit = this.doctypeSystem.indexOf(34) >= 0 ? (char)'\'' : '\"';
                this.write(' ');
                this.write(lit);
                this.write(this.doctypeSystem);
                this.write(lit);
            }
            this.write('>');
            this.doctypeSystem = null;
            this.doctypePublic = null;
            this.write(this.lineSeparator);
        }
        int flags = HTMLOutputHandler.getElementTypeFlags(qName);
        int contentType = flags & 3;
        boolean bl = isBlockElement = (flags & 4) != 0;
        if (this.inPcdataChunk) {
            this.inPcdataChunk = false;
        } else if (this.indent && (!this.inBlock || isBlockElement)) {
            this.write(this.lineSeparator);
        }
        this.inBlock = !isBlockElement;
        this.write('<');
        this.write(qName);
        int nAtts = atts.getLength();
        for (int i = 0; i < nAtts; ++i) {
            this.attribute(atts.getQName(i), atts.getValue(i));
        }
        if (contentType == 2) {
            this.inCdata = true;
        }
        this.write('>');
        if (this.encoding != null && (flags & 8) != 0) {
            this.write(this.lineSeparator + "<META http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.encoding + "\">");
        }
    }

    public void rawCharacters(String chars) throws SAXException {
        if (chars.length() != 0) {
            this.writeUnquoted(chars);
            this.inPcdataChunk = true;
        }
    }

    private void writeUnquoted(String str) throws SAXException {
        int i;
        int start = 0;
        while ((i = str.indexOf(10, start)) >= 0) {
            if (i > start) {
                this.write(str.substring(start, i));
            }
            this.write(this.lineSeparator);
            start = i + 1;
        }
        this.write(start == 0 ? str : str.substring(start));
    }

    private void attribute(String name, String value) throws SAXException {
        this.write(' ');
        this.write(name);
        if (!HTMLOutputHandler.isBooleanAttribute(name, value)) {
            this.write('=');
            this.write('\"');
            int len = value.length();
            block6: for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '\n': {
                        this.write(this.lineSeparator);
                        continue block6;
                    }
                    case '&': {
                        if (i + 1 < len && value.charAt(i + 1) == '{') {
                            this.write(c);
                            continue block6;
                        }
                        this.write("&amp;");
                        continue block6;
                    }
                    case '\"': {
                        this.write("&quot;");
                        continue block6;
                    }
                    case '\u00a0': {
                        this.write("&nbsp;");
                        continue block6;
                    }
                    default: {
                        if (c <= this.maxRepresentableChar) {
                            this.write(c);
                            continue block6;
                        }
                        this.write(HTMLOutputHandler.getCharString(c));
                    }
                }
            }
            this.write('\"');
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        boolean isBlockElement;
        int flags = HTMLOutputHandler.getElementTypeFlags(qName);
        int contentType = flags & 3;
        boolean bl = isBlockElement = (flags & 4) != 0;
        if (contentType != 1) {
            if (this.inPcdataChunk) {
                this.inPcdataChunk = false;
            } else if (this.indent && (!this.inBlock || isBlockElement)) {
                this.write(this.lineSeparator);
            }
            this.inBlock = !isBlockElement;
            this.write('<');
            this.write('/');
            this.write(qName);
            this.write('>');
        }
        if ((flags & 0x10) != 0) {
            this.inPcdataChunk = true;
        }
        this.inCdata = false;
    }

    public void comment(String str) throws SAXException {
        this.write("<!--");
        this.writeUnquoted(str);
        this.write("-->");
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (target == null) {
            this.comment(data);
            return;
        }
        this.write("<?");
        this.write(target);
        if (data.length() != 0) {
            this.write(' ');
            this.writeUnquoted(data);
        }
        this.write('>');
    }

    private static String getCharString(char c) {
        String name;
        String[] v = charMap[c >> 8];
        if (v == null) {
            v = new String[256];
            HTMLOutputHandler.charMap[c >> 8] = v;
        }
        if ((name = v[c & 0xFF]) == null) {
            v[c & 0xFF] = name = "&#" + Integer.toString(c) + ";";
        }
        return name;
    }

    private static int getElementTypeFlags(String name) {
        Integer type = (Integer)elementTypeTable.get(name.toLowerCase());
        if (type == null) {
            return 0;
        }
        return type;
    }

    private static boolean isBooleanAttribute(String name, String value) {
        if (!name.equalsIgnoreCase(value)) {
            return false;
        }
        return booleanAttributesTable.get(name.toLowerCase()) != null;
    }

    private final void write(String s) throws SAXException {
        int len;
        int start = 0;
        int avail = this.buf.length - this.bufUsed;
        for (len = s.length(); avail < len; len -= avail) {
            s.getChars(start, start + avail, this.buf, this.bufUsed);
            this.bufUsed = this.buf.length;
            this.flushBuf();
            start += avail;
            avail = this.buf.length;
        }
        s.getChars(start, start + len, this.buf, this.bufUsed);
        this.bufUsed += len;
    }

    private final void write(char b) throws SAXException {
        if (this.bufUsed == this.buf.length) {
            this.flushBuf();
        }
        this.buf[this.bufUsed++] = b;
    }

    private final void flushBuf() throws SAXException {
        try {
            this.writer.write(this.buf, 0, this.bufUsed);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        this.bufUsed = 0;
    }

    public void endDocument() throws SAXException {
        this.write(this.lineSeparator);
        if (this.bufUsed != 0) {
            this.flushBuf();
        }
        try {
            if (this.keepOpen) {
                this.writer.flush();
            } else {
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        this.writer = null;
        this.buf = null;
    }

    public void setDocumentLocator(Locator loc) {
    }

    static {
        int i;
        emptyElements = new String[]{"area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param"};
        cdataElements = new String[]{"script", "style"};
        blockElements = new String[]{"address", "area", "base", "blockquote", "body", "br", "caption", "center", "col", "colgroup", "dd", "dir", "div", "dl", "dt", "fieldset", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "hr", "html", "isindex", "li", "link", "map", "menu", "meta", "noframes", "noscript", "ol", "p", "pre", "style", "table", "tbody", "tfoot", "thead", "title", "tr", "ul"};
        pcdataElements = new String[]{"applet", "img", "object"};
        booleanAttributes = new String[]{"checked", "compact", "declare", "defer", "disabled", "ismap", "multiple", "nohref", "noresize", "noshade", "nowrap", "readonly", "selected"};
        charEntities = new String[]{"\u00a0nbsp", "\u00a1iexcl", "\u00a2cent", "\u00a3pound", "\u00a4curren", "\u00a5yen", "\u00a6brvbar", "\u00a7sect", "\u00a8uml", "\u00a9copy", "\u00aaordf", "\u00ablaquo", "\u00acnot", "\u00adshy", "\u00aereg", "\u00afmacr", "\u00b0deg", "\u00b1plusmn", "\u00b2sup2", "\u00b3sup3", "\u00b4acute", "\u00b5micro", "\u00b6para", "\u00b7middot", "\u00b8cedil", "\u00b9sup1", "\u00baordm", "\u00bbraquo", "\u00bcfrac14", "\u00bdfrac12", "\u00befrac34", "\u00bfiquest", "\u00c0Agrave", "\u00c1Aacute", "\u00c2Acirc", "\u00c3Atilde", "\u00c4Auml", "\u00c5Aring", "\u00c6AElig", "\u00c7Ccedil", "\u00c8Egrave", "\u00c9Eacute", "\u00caEcirc", "\u00cbEuml", "\u00ccIgrave", "\u00cdIacute", "\u00ceIcirc", "\u00cfIuml", "\u00d0ETH", "\u00d1Ntilde", "\u00d2Ograve", "\u00d3Oacute", "\u00d4Ocirc", "\u00d5Otilde", "\u00d6Ouml", "\u00d7times", "\u00d8Oslash", "\u00d9Ugrave", "\u00daUacute", "\u00dbUcirc", "\u00dcUuml", "\u00ddYacute", "\u00deTHORN", "\u00dfszlig", "\u00e0agrave", "\u00e1aacute", "\u00e2acirc", "\u00e3atilde", "\u00e4auml", "\u00e5aring", "\u00e6aelig", "\u00e7ccedil", "\u00e8egrave", "\u00e9eacute", "\u00eaecirc", "\u00ebeuml", "\u00ecigrave", "\u00ediacute", "\u00eeicirc", "\u00efiuml", "\u00f0eth", "\u00f1ntilde", "\u00f2ograve", "\u00f3oacute", "\u00f4ocirc", "\u00f5otilde", "\u00f6ouml", "\u00f7divide", "\u00f8oslash", "\u00f9ugrave", "\u00fauacute", "\u00fbucirc", "\u00fcuuml", "\u00fdyacute", "\u00fethorn", "\u00ffyuml", "\u0152OElig", "\u0153oelig", "\u0160Scaron", "\u0161scaron", "\u0178Yuml", "\u0192fnof", "\u02c6circ", "\u02dctilde", "\u0391Alpha", "\u0392Beta", "\u0393Gamma", "\u0394Delta", "\u0395Epsilon", "\u0396Zeta", "\u0397Eta", "\u0398Theta", "\u0399Iota", "\u039aKappa", "\u039bLambda", "\u039cMu", "\u039dNu", "\u039eXi", "\u039fOmicron", "\u03a0Pi", "\u03a1Rho", "\u03a3Sigma", "\u03a4Tau", "\u03a5Upsilon", "\u03a6Phi", "\u03a7Chi", "\u03a8Psi", "\u03a9Omega", "\u03b1alpha", "\u03b2beta", "\u03b3gamma", "\u03b4delta", "\u03b5epsilon", "\u03b6zeta", "\u03b7eta", "\u03b8theta", "\u03b9iota", "\u03bakappa", "\u03bblambda", "\u03bcmu", "\u03bdnu", "\u03bexi", "\u03bfomicron", "\u03c0pi", "\u03c1rho", "\u03c2sigmaf", "\u03c3sigma", "\u03c4tau", "\u03c5upsilon", "\u03c6phi", "\u03c7chi", "\u03c8psi", "\u03c9omega", "\u03d1thetasym", "\u03d2upsih", "\u03d6piv", "\u2002ensp", "\u2003emsp", "\u2009thinsp", "\u200czwnj", "\u200dzwj", "\u200elrm", "\u200frlm", "\u2013ndash", "\u2014mdash", "\u2018lsquo", "\u2019rsquo", "\u201asbquo", "\u201cldquo", "\u201drdquo", "\u201ebdquo", "\u2020dagger", "\u2021Dagger", "\u2022bull", "\u2026hellip", "\u2030permil", "\u2032prime", "\u2033Prime", "\u2039lsaquo", "\u203arsaquo", "\u203eoline", "\u2044frasl", "\u20aceuro", "\u2111image", "\u2118weierp", "\u211creal", "\u2122trade", "\u2135alefsym", "\u2190larr", "\u2191uarr", "\u2192rarr", "\u2193darr", "\u2194harr", "\u21b5crarr", "\u21d0lArr", "\u21d1uArr", "\u21d2rArr", "\u21d3dArr", "\u21d4hArr", "\u2200forall", "\u2202part", "\u2203exist", "\u2205empty", "\u2207nabla", "\u2208isin", "\u2209notin", "\u220bni", "\u220fprod", "\u2211sum", "\u2212minus", "\u2217lowast", "\u221aradic", "\u221dprop", "\u221einfin", "\u2220ang", "\u2227and", "\u2228or", "\u2229cap", "\u222acup", "\u222bint", "\u2234there4", "\u223csim", "\u2245cong", "\u2248asymp", "\u2260ne", "\u2261equiv", "\u2264le", "\u2265ge", "\u2282sub", "\u2283sup", "\u2284nsub", "\u2286sube", "\u2287supe", "\u2295oplus", "\u2297otimes", "\u22a5perp", "\u22c5sdot", "\u2308lceil", "\u2309rceil", "\u230alfloor", "\u230brfloor", "\u2329lang", "\u232arang", "\u25caloz", "\u2660spades", "\u2663clubs", "\u2665hearts", "\u2666diams"};
        charMap = new String[256][];
        elementTypeTable = new Hashtable();
        booleanAttributesTable = new Hashtable();
        for (int i2 = 0; i2 < charEntities.length; ++i2) {
            char c = charEntities[i2].charAt(0);
            int lo = c & 0xFF;
            int hi = c >> 8;
            if (charMap[hi] == null) {
                HTMLOutputHandler.charMap[hi] = new String[256];
            }
            HTMLOutputHandler.charMap[hi][lo] = "&" + charEntities[i2].substring(1) + ";";
        }
        char[] charBuf = new char[1];
        for (int i3 = 0; i3 < 128; ++i3) {
            if (charMap[0][i3] != null) continue;
            charBuf[0] = (char)i3;
            HTMLOutputHandler.charMap[0][i3] = new String(charBuf);
        }
        Integer type = new Integer(4);
        for (int i4 = 0; i4 < blockElements.length; ++i4) {
            elementTypeTable.put(blockElements[i4], type);
        }
        Integer blockType = new Integer(5);
        Integer inlineType = new Integer(1);
        for (i = 0; i < emptyElements.length; ++i) {
            type = elementTypeTable.get(emptyElements[i]) == null ? inlineType : blockType;
            elementTypeTable.put(emptyElements[i], type);
        }
        blockType = new Integer(6);
        inlineType = new Integer(2);
        for (i = 0; i < cdataElements.length; ++i) {
            type = elementTypeTable.get(cdataElements[i]) == null ? inlineType : blockType;
            elementTypeTable.put(cdataElements[i], type);
        }
        for (i = 0; i < pcdataElements.length; ++i) {
            type = (Integer)elementTypeTable.get(pcdataElements[i]);
            type = type == null ? new Integer(16) : new Integer(0x10 | type);
            elementTypeTable.put(pcdataElements[i], type);
        }
        for (i = 0; i < booleanAttributes.length; ++i) {
            booleanAttributesTable.put(booleanAttributes[i], booleanAttributes[i]);
        }
        elementTypeTable.put("head", new Integer(12));
    }
}

