/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.ArrayNodeIterator;
import com.jclark.xsl.expr.ConvertibleExpr;
import com.jclark.xsl.expr.ConvertibleNodeSetExpr;
import com.jclark.xsl.expr.ConvertibleStringExpr;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.Function;
import com.jclark.xsl.expr.LiteralExpr;
import com.jclark.xsl.expr.ParseException;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XSLException;
import java.net.URL;

class SplitFunction
implements Function {
    SplitFunction() {
    }

    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] args, Node exprNode) throws ParseException {
        if (args.length < 2 || args.length > 3) {
            throw new ParseException("expected 2 or 3 arguments");
        }
        final ConvertibleStringExpr srcSe = args[0].makeStringExpr();
        final ConvertibleStringExpr sepSe = args.length == 2 ? args[1].makeStringExpr() : new LiteralExpr(" ");
        return new ConvertibleNodeSetExpr(){

            public NodeIterator eval(Node node, ExprContext context) throws XSLException {
                return SplitFunction.split(node, context, srcSe.eval(node, context), sepSe.eval(node, context));
            }
        };
    }

    private static final NodeIterator split(Node node, ExprContext context, String src, String separator) throws XSLException {
        String[] tokens = src.split(separator);
        Node[] nodes = new Node[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            RegexTextNode textNode = new RegexTextNode(tokens[i], i, node);
            nodes[i] = textNode;
        }
        return new ArrayNodeIterator(nodes, 0, nodes.length);
    }

    private static class RegexNodeIterator
    implements SafeNodeIterator {
        private Node nextNode;

        RegexNodeIterator(Node nextNode) {
            this.nextNode = nextNode;
        }

        public Node next() {
            return null;
        }
    }

    private static class RegexTextNode
    implements Node {
        Node _parent;
        Node _root;
        int _index;
        Node _nextSibling;
        private String _data;

        RegexTextNode(String regexGroupText, int index, Node parent) {
            this._parent = parent;
            this._index = index;
            this._data = regexGroupText;
            this._root = this._parent.getRoot();
            this._nextSibling = null;
        }

        public Node getParent() {
            return this._parent;
        }

        public SafeNodeIterator getFollowingSiblings() {
            return new RegexNodeIterator(null);
        }

        public URL getURL() {
            return this._parent.getURL();
        }

        boolean canStrip() {
            return false;
        }

        public Node getAttribute(Name name) {
            return null;
        }

        public String getAttributeValue(Name name) {
            return null;
        }

        public SafeNodeIterator getAttributes() {
            return new RegexNodeIterator(null);
        }

        public SafeNodeIterator getNamespaces() {
            return new RegexNodeIterator(null);
        }

        public Name getName() {
            return null;
        }

        public NamespacePrefixMap getNamespacePrefixMap() {
            return this.getParent().getNamespacePrefixMap();
        }

        public int compareTo(Node node) {
            return -1;
        }

        public Node getElementWithId(String name) {
            return this._root.getElementWithId(name);
        }

        public String getUnparsedEntityURI(String name) {
            return this._root.getUnparsedEntityURI(name);
        }

        public boolean isId(String name) {
            return false;
        }

        public String getGeneratedId() {
            int d = this._index;
            if (d == 0) {
                return "N" + String.valueOf(this._index);
            }
            return "N" + String.valueOf(d) + "_" + String.valueOf(this._index);
        }

        public Node getRoot() {
            return this._root;
        }

        public int getLineNumber() {
            return this._parent.getLineNumber();
        }

        public int getColumnNumber() {
            return -1;
        }

        public String getSystemId() {
            return this.getRoot().getSystemId();
        }

        public String getPublicId() {
            return null;
        }

        public byte getType() {
            return 1;
        }

        public String getData() {
            return this._data;
        }

        public SafeNodeIterator getChildren() {
            return new RegexNodeIterator(null);
        }
    }
}

