/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SYNCML_H
#define _SYNCML_H

#include <unistd.h>
#include <sys/types.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************
 * Defines
 *************************************************************/
#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/**************************************************************
 * Structs
 *************************************************************/
typedef struct SmlError SmlError;
typedef struct SmlTransport SmlTransport;
typedef struct SmlParser SmlParser;
typedef struct SmlAssembler SmlAssembler;
typedef struct SmlCommand SmlCommand;
typedef struct SmlLocation SmlLocation;
typedef struct SmlStatus SmlStatus;
typedef struct SmlSession SmlSession;
typedef struct SmlAnchor SmlAnchor;
typedef struct SmlPendingStatus SmlPendingStatus;
typedef struct SmlItem SmlItem;
typedef struct SmlDevInf SmlDevInf;
typedef struct SmlDevInfDataStore SmlDevInfDataStore;
typedef struct SmlNotification SmlNotification;
typedef struct SmlSanAlert SmlSanAlert;
typedef struct SmlMapItem SmlMapItem;
typedef struct SmlCred SmlCred;
typedef struct SmlHeader SmlHeader;
typedef struct SmlTransportData SmlTransportData;
typedef struct SmlObject SmlObject;
typedef struct SmlManager SmlManager;
typedef struct SmlLink SmlLink;
typedef int SmlBool;

#include <libsyncml/sml_defines.h>
#include <libsyncml/sml_error.h>
#include <libsyncml/sml_manager.h>
#include <libsyncml/sml_session.h>
#include <libsyncml/sml_transport.h>
#include <libsyncml/sml_elements.h>
#include <libsyncml/sml_command.h>
#include <libsyncml/sml_devinf.h>
#include <libsyncml/sml_notification.h>
#include <libsyncml/sml_base64.h>
#include <libsyncml/sml_md5.h>

#ifdef __cplusplus
}
#endif

#endif
