#ifndef __INCLUDED_PHIDGETS_CONSTANTS_H__
#define __INCLUDED_PHIDGETS_CONSTANTS_H__

#define PHIDGETS_USB_TIMEOUT 60

#define PHIDGETS_USB_VENDORID 0x06C2

#define PHIDGETS_USB_PRODUCTID_RFID 0x0031

#define PHIDGETS_USB_PRODUCTID_QUADSERVO 0x0038

#define PHIDGETS_USB_PRODUCTID_INTERFACEKIT_0_0_4 0x0040
#define PHIDGETS_USB_PRODUCTID_INTERFACEKIT_0_16_16 0x0044
#define PHIDGETS_USB_PRODUCTID_INTERFACEKIT_8_8_8 0x0045
#define PHIDGETS_USB_PRODUCTID_INTERFACEKIT_0_5_7 0x0051
#define PHIDGETS_USB_PRODUCTID_INTERFACEKIT_0_8_8 0x0053

#define PHIDGETS_USB_PRODUCTID_LED64 0x004a

/* InterfaceKit 0/5/7 = AnalogIn / DigitalIn / DigitalOut */
#define PHIDGETS_INTERFACEKIT_MAX_ANALOG_INPUTS 8
#define PHIDGETS_INTERFACEKIT_MAX_DIGITAL_INPUTS 16
#define PHIDGETS_INTERFACEKIT_MAX_DIGITAL_OUTPUTS 16

#define PHIDGETS_INTERFACEKIT_USB_PACKET_LENGTH 4

#define PHIDGETS_HID_PATH_DEPTH 3
#define PHIDGETS_HID_PATH_1 0xffa00001
#define PHIDGETS_HID_PATH_2 0xffa00002
#define PHIDGETS_HID_PATH_INTERFACEKIT_DIGITAL_OUTPUT_SET 0xffa10008
#define PHIDGETS_HID_PATH_INTERFACEKIT_DIGITAL_OUTPUT_GET 0xffa10000
#define PHIDGETS_HID_PATH_RFID_SET 0xffa1000b
#define PHIDGETS_HID_PATH_LED64_SET 0xffa10008

#define PHIDGETS_RFID_SET_PACKETLEN 4
#define PHIDGETS_RFID_GET_PACKETLEN 7

/* Bitfield for setting the state on the RFID reader */
#define PHIDGETS_RFID_PLUS_FIVE 0x1
#define PHIDGETS_RFID_EXTERNAL_LED 0x2
#define PHIDGETS_RFID_ONBOARD_LED 0x4
#define PHIDGETS_RFID_ENABLE 0x8

#define PHIDGETS_LED64_NUMLEDS 64
#define PHIDGETS_LED64_SET_PACKETLEN 8

#define USB_CONTROL_DATA_SOMETHINGELSE 0x80
#define USB_CONTROL_DATA_WRITE 0x40
#define USB_CONTROL_DATA_READ 0x00

#define USB_CONTROL_TYPE_STANDARD 0x00
#define USB_CONTROL_TYPE_CLASS 0x10
#define USB_CONTROL_TYPE_VENDOR 0x20

#define USB_CONTROL_RECIPIENT_DEVICE 0x00
#define USB_CONTROL_RECIPIENT_INTERFACE 0x01
#define USB_CONTROL_RECIPIENT_ENDPOINT 0x02
#define USB_CONTROL_RECIPIENT_OTHER 0x03

#define USB_CONTROL_REQUESTCODE_GET_CONFIGURATION 0x8
#define USB_CONTROL_REQUESTCODE_SET_CONFIGURATION 0x9


#endif /* __INCLUDED_PHIDGETS_CONSTANTS_H__ */

/* COPYRIGHT --
 *
 * This file is part of libphidgets, a user-space library for phidgets.
 * libphidgets is (c) 2003-2005 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
