/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: PrintStreamLogger.java,v 1.3 2004/12/12 05:29:33 pietschy Exp $
 */

package org.pietschy.command.log;

import java.io.PrintStream;

public class
PrintStreamLogger
implements Logger
{
   static final String _ID_ = "$Id: PrintStreamLogger.java,v 1.3 2004/12/12 05:29:33 pietschy Exp $";

   private PrintStream out;
   private Class clazz;

   public PrintStreamLogger(Class aClass, PrintStream out)
   {
      this.clazz = aClass;
      this.out = out;
   }

   public boolean isDebugEnabled()
   {
      return true;
   }

   public boolean isErrorEnabled()
   {
      return true;
   }

   public boolean isFatalEnabled()
   {
      return true;
   }

   public boolean isInfoEnabled()
   {
      return true;
   }

   public boolean isTraceEnabled()
   {
      return true;
   }

   public boolean isWarnEnabled()
   {
      return true;
   }

   private void println(Object o)
   {
      out.println(clazz.getName() + "|" + o);
   }

   public void trace(Object o)
   {
      println(o);
   }

   public void trace(Object o, Throwable throwable)
   {
      trace(o);
      throwable.printStackTrace(out);
   }

   public void debug(Object o)
   {
      println(o);
   }

   public void debug(Object o, Throwable throwable)
   {
      debug(o);
      throwable.printStackTrace(out);
   }

   public void info(Object o)
   {
      println(o);
   }

   public void info(Object o, Throwable throwable)
   {
      info(o);
      throwable.printStackTrace(out);
   }

   public void warn(Object o)
   {
      println(o);
   }

   public void warn(Object o, Throwable throwable)
   {
      warn(o);
      throwable.printStackTrace(out);
   }

   public void error(Object o)
   {
      println(o);
   }

   public void error(Object o, Throwable throwable)
   {
      error(o);
      throwable.printStackTrace(out);
   }

   public void fatal(Object o)
   {
      println(o);
   }

   public void fatal(Object o, Throwable throwable)
   {
      fatal(o);
      throwable.printStackTrace(out);
   }

   public boolean isEnterEnabled()
   {
      return true;
   }

   public void enter(Object o)
   {
      trace(">>" + o);
   }

   public boolean isExitEnabled()
   {
      return true;
   }

   public void exit(Object o)
   {
      trace("<<" + o);
   }

   public boolean isParamEnabled()
   {
      return true;
   }

   public void param(String name, Object param)
   {
      println(name + ":" + param);
   }

   public boolean isReturnedEnabled()
   {
      return true;
   }

   public void returned(Object o)
   {
      println("** " + o);
   }
}
