// $Id: WelcomePanel.java,v 1.7 2006/02/26 00:59:09 pietschy Exp $
// Copyright (c) 2000-2001 The Forge Group. All rights reserved.
/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: WelcomePanel.java,v 1.7 2006/02/26 00:59:09 pietschy Exp $
 */
package org.pietschy.command.demo.welcome;

import au.com.skypie.ui.HTMLPane;
import org.pietschy.command.CommandGroup;
import org.pietschy.command.CommandHyperlinkListener;
import org.pietschy.command.demo.DemoPanel;

import javax.swing.*;
import java.awt.*;
import java.io.IOException;

public class
WelcomePanel
extends DemoPanel
{
   static final String _ID_ = "$Id: WelcomePanel.java,v 1.7 2006/02/26 00:59:09 pietschy Exp $";
   private CommandGroup[] groupCommands = new CommandGroup[0];

   public WelcomePanel()
   {
      super("Welcome", "welcome-page.selector", "welcome-commands.xml");

      HTMLPane html = new HTMLPane();
      try
      {
         html.setPage(getClass().getResource("welcome.html"));
      }
      catch (IOException e)
      {
         throw new RuntimeException("Couldn't load welcome.html", e);
      }
//      html.setAntiAlias(true);
      html.addHyperlinkListener(new CommandHyperlinkListener());

      setLayout(new BorderLayout());
      add(new JScrollPane(html), BorderLayout.CENTER);
   }

   public CommandGroup[]
   getMenuGroups()
   {
      return groupCommands;
   }

   public CommandGroup
   getToolbarGroup()
   {
      return null;
   }
}
