/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: UndoDemoPanel.java,v 1.7 2006/02/26 00:59:09 pietschy Exp $
 */

package org.pietschy.command.demo.undo;

import au.com.skypie.ui.HTMLPane;
import org.pietschy.command.CommandGroup;
import org.pietschy.command.CommandManager;
import org.pietschy.command.DefaultToolbarFactory;
import org.pietschy.command.demo.AbstractDemoPanel;
import org.pietschy.command.undo.UndoController;
import org.pietschy.explicit.TableBuilder;

import javax.swing.*;
import java.awt.*;
import java.io.IOException;

public class
UndoDemoPanel
extends AbstractDemoPanel
{
   static final String _ID_ = "$Id: UndoDemoPanel.java,v 1.7 2006/02/26 00:59:09 pietschy Exp $";

   private CommandGroup[] menus;
   private JTextPane textPane;

   public UndoDemoPanel()
   {
      super("Undo Examples", "undo-page.selector", "undo-commands.xml");
   }


   public void
   loadBlurb(HTMLPane html)
   {
      try
      {
         html.setPage(getClass().getResource("undo.html"));
      }
      catch (IOException e)
      {
         throw new RuntimeException("Couldn't load undo file", e);
      }
   }

   public JComponent
   createExamplePanel()
   {
      CommandManager cm = CommandManager.defaultInstance();

      textPane = new JTextPane();

      UndoController undoController = new UndoController(cm);
      undoController.getUndoCommand();
      undoController.getRedoCommand();

      DefaultToolbarFactory factory = new DefaultToolbarFactory(new Insets(2, 5, 2, 5),
                                                                false,
                                                                false);

      menus = new CommandGroup[] {cm.getGroup("undo-page.menu")};

      new SimpleUndoToggle("undo-page.toggle-bold", textPane);
      new SimpleUndoToggle("undo-page.toggle-italic", textPane);
      new SimpleUndoToggle("undo-page.toggle-underline", textPane);

      SimpleUndoToggle left = new SimpleUndoToggle("undo-page.toggle-left", textPane);
      left.setSelected(true);
      new SimpleUndoToggle("undo-page.toggle-right", textPane);
      new SimpleUndoToggle("undo-page.toggle-centre", textPane);
      new SimpleUndoToggle("undo-page.toggle-justify", textPane);


      TableBuilder builder = new TableBuilder();
      builder.rows().defaultPaddingTop(builder.layoutStyle().unrelatedRowGap());
      builder.row(0).paddingTop(0);
      int row = 0;

      builder.addXY(menus[0].createToolBar(factory), 0, row++);
      builder.addXY(new JScrollPane(textPane), 0, row)
      .fillX().fillY()
      .minimumWidth(0);
      builder.firstColumn().grow(1.0);
      builder.row(1).grow(1.0);
      builder.row(1).paddingTop(1.0);

      builder.margin(builder.layoutStyle().tabbedDialogMargin());
      builder.buildLayout();

      return builder.getPanel();
   }

   public CommandGroup[]
   getMenuGroups()
   {
      return menus;
   }

   public CommandGroup
   getToolbarGroup()
   {
      return null;//menus[0];
   }

}
