/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: CommandManagerEvent.java,v 1.3 2004/12/12 05:29:20 pietschy Exp $
 */

package org.pietschy.command;

import java.util.EventObject;

/**
 * Fired when a command is registered with a {@link CommandManager}.
 * @see CommandManager#addCommandManagerListener
 */
public class
CommandManagerEvent
extends EventObject
{

   private Command command;

   /**
    * Constructs a new event.
    * @param source the command container to which the command was registered.
    * @param command the {@link Command} that was registered.
    */
   public CommandManagerEvent(CommandManager source, Command command)
   {
      super(source);
      this.command = command;
   }

   /**
    * Gets the command that was registered.
    * @return the newly registered {@link Command}.
    */
   public Command getCommand()
   {
      return command;
   }
}
