/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: CommandListener.java,v 1.6 2005/07/10 06:46:40 pietschy Exp $
 */

package org.pietschy.command;

import java.util.EventListener;

/**
 * The CommandListener interface provides notification of a commands execution.  The
 * listener is notified just before and just after the command has been invoked.
 * @deprecated use {@link ActionCommandInterceptor} instead.
 */
public interface
CommandListener
extends EventListener
{
    /**
    * Called just prior to a commands execution.
    * @param e the command event.
    */
   public void beforeExecute(CommandEvent e);

    /**
    * Called just after a commands execution.
    * @param e the command event.
    */
   public void afterExecute(CommandEvent e);
}
