/** -*- C++ -*-
    @file filters.cpp
    @author Peter Rockai <me@mornfall.net>
*/

#include <ept/tests/test-utils.h>

#include <wibble/range.h>
#include <list>

#include <ept/predicate/matchers.h>
#include <ept/predicate/combinators.h>
#include <ept/predicate/factory.h>

#include <ept/cache/package.h>
#include <ept/cache/apt/packages.h>
#include <ept/cache/cache.h>

namespace tut {

using namespace ept;
using namespace wibble;
using namespace configuration::apt;

struct predicate_matchers_shar : common {};
TESTGRP( predicate_matchers );

template<> template<>
void to::test<1> ()
{
    std::list< cache::Package > v;
    std::list< cache::Package >::iterator i;

    cache::Package p;
    Range< cache::Package > fr = filteredRange(
        apt.index().range(), match::Package::name( "exim4-config-2" ) );

    fr.output( consumer( v ) );

    for (i = v.begin(); i != v.end(); ++i) {
        ensure_equals( i->name(), "exim4-config-2" );
    }
}

template<> template<>
void to::test<2> ()
{
    std::list< cache::Package > v;
    std::list< cache::Package >::iterator i;
    std::remove_copy_if(
        apt.index().begin(),
        apt.index().end(),
        back_inserter( v ),
        not match::Package::shortDescription( "exim4" ) );
    for (i = v.begin(); i != v.end(); ++i) {
        ensure_equals( i->name(), "exim4-config" );
    }
}

template<> template<>
void to::test<3> ()
{
    std::set< cache::Package > v;
    std::set< cache::Package >::iterator i;
    std::remove_copy_if(
        apt.index().begin(),
        apt.index().end(),
        inserter( v, v.begin() ),
        not match::Package::shortDescription( "exim4" ) );
    for (i = v.begin(); i != v.end(); ++i) {
        ensure_equals( i->name(), "exim4-config" );
    }
}

template<> template<>
void to::test<4> ()
{
    Range< cache::Package > fr = filteredRange(
        apt.index().range(), match::Package::shortDescription( "exim4" ) );
    while ( !fr.empty() ) {
        ensure_equals( fr.head().name(), "exim4-config" );
        fr = fr.tail();
    }
}

template<> template<>
void to::test<5> ()
{
    Range< cache::Package > fr = filteredRange(
        apt.index().range(), match::Package::shortDescription( "exim4" ) );
    std::vector< cache::Package > v;
    fr.output( consumer( v ) );
    ensure( v.size() > 0 );
    for ( std::vector< cache::Package >::iterator i = v.begin(); i != v.end(); ++i ) {
        ensure_equals( i->name(), "exim4-config" );
    }
}

template<> template<>
void to::test<6> ()
{
    Range< cache::Entity > r =
        upcastRange< cache::Entity >( apt.index().range() );
    cache::Package p;
    Range< cache::Entity > fr = filteredRange(
        r, predicate::adapt< cache::Entity >(
            match::Package::shortDescription( "exim4" ) ) );
    while ( !fr.empty() ) {
        p = downcast< cache::Package >( fr.head() );
        ensure_equals( p.name(), "exim4-config" );
        fr = fr.tail();
    }
}

template<> template<>
void to::test<7> ()
{
    std::list< cache::Package > v;
    std::list< cache::Package >::iterator i;

    cache::Package p;
    Range< cache::Package > fr = filteredRange(
        apt.index().range(), match::Package::maintainer( "enrico@debian.org" ) );

    std::copy( fr.begin(), fr.end(), back_inserter( v ) );
    ensure( !v.empty() );

    std::set<string> allowed;
    allowed.insert("libtagcoll0");
    allowed.insert("log2mail");
    allowed.insert("libdebtags0");
    allowed.insert("libdebtags-dev");
    allowed.insert("tagcoll");
    allowed.insert("debtags");
    allowed.insert("guessnet");
    allowed.insert("buffy");
    allowed.insert("libtagcoll-dev");
    allowed.insert("launchtool");
    allowed.insert("debtags-edit");
    allowed.insert("tagcolledit");

    /* This is left here to allow to recheck the list if the test dataset
     * changes
    fprintf(stderr, "--> %d %d <--\n", v.size(), allowed.size());
    for (i =v.begin(); i != v.end(); ++i)
	    fprintf(stderr, "GOT: %s\n", i->name().c_str());
    */

    ensure_equals( v.size(), allowed.size() );

    for (i = v.begin(); i != v.end(); ++i) {
        ensure( allowed.find(i->name()) != allowed.end() );
    }
}

#if 0 // debtags
template<> template<>
void to::test<8>()
{
    VectorRange< entity::Package > r;
    c.packages().packages( consumer( r ) );
    entity::Package p = c.packages().packageByName( "debtags" );
    ensure(p.valid());
    Tagcoll::OpSet<entity::Tag> tags = p.tags();
    ensure(!tags.empty());
    Range< entity::Package > x, f = filteredRange(
        range( r ), predicate::Package::tag( tags ) );
    x = std::find( f, f.end(), p );
    ensure_equals( x->name(), "debtags" );
}
#endif

template<> template<>
void to::test<9> ()
{
    cache::Package p;
    Range< cache::Package > fr = filteredRange(
        apt.index().range(), match::Package::member( &cache::Package::hasVersion ) );
    ensure( std::distance( fr.begin(), fr.end() ) > 0 );
}

template<> template<>
void to::test<10> ()
{
    Range< cache::Package > fr = filteredRange(
        apt.index().range(), match::Package::name( "exim4" )
        and match::Package::member( &cache::Package::hasVersion ) );
    ensure( std::distance( fr.begin(), fr.end() ) > 0 );
    while ( !fr.empty() ) {
        // do something to vr.head()
        fr = fr.tail();
    }
}

}
