// -*- mode: c++; tab-width: 4; indent-tabs-mode: t -*-
/**
 * @file cache/component/tagmap.cpp
 * @author Enrico Zini (enrico) <enrico@enricozini.org>
 */

/*
 * Tests for cache/debtags/utils
 *
 * Copyright (C) 2003-2006  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#include <ept/tests/test-utils.h>
#include <ept/cache/debtags/tagmap.h>
#include <ept/cache/debtags/utils.h>

#include <tagcoll/stream/sink.h>
#include <tagcoll/coll/fast.h>

#if 0
#include <ept/cache/cache.h>
#include <ept/cache/tag.h>
#include <ept/cache/debtags/vocabulary.h>
#include <tagcoll/utils/set.h>
#endif

using namespace tagcoll;
using namespace ept;
using namespace ept::configuration::apt;
using namespace wibble::operators;
using namespace cache;

namespace tut {

struct cache_debtags_utils_shar : common {
    TagMap& pt() { return apt.tagMap(); }
};

TESTGRP( cache_debtags_utils );

template<> template<>
void to::test<1>()
{
	// pt().output outputs some items more than once, so we compact it in a
	// coll::Fast
	coll::Fast<Package, Tag> tmp;
	pt().output(inserter(tmp));

	coll::Fast<Package, Facet> facetColl;
	tmp.output(DebtagsUtils::tagToFacet(inserter(facetColl)));

	int items = 0, tags = 0;
	tmp.output(stream::countingSink(items, tags));
	ensure(items > 10);
	ensure(tags > 10);

	int fitems = 0, ftags = 0;
	facetColl.output(stream::countingSink(fitems, ftags));

	ensure(ftags > 0);

#if 0
	// See what packages have been left out
	using namespace std;

	set<Package> pkgs1 = tmp.getTaggedItems();
	set<Package> pkgs2 = facetColl.getTaggedItems();
	cerr << "Itemset sizes: full: " << pkgs1.size() << " facetColl: " << pkgs2.size() << endl;
	set<Package> diff = pkgs1 - pkgs2;
	cerr << diff.size() << " items disappeared" << endl;
	for (set<Package>::const_iterator i = diff.begin(); i != diff.end(); ++i)
	{
		cerr << "Disappeared: " << i->name() << ":";
		set<Tag> tags = tmp.getTagsOfItem(*i);
		for (set<Tag>::const_iterator j = tags.begin(); j != tags.end(); ++j)
			cerr << " " << j->fullname();
		cerr << endl;
	}
#endif

	ensure_equals(fitems, items);
	ensure(ftags < tags);
}

}

#include <tagcoll/coll/fast.tcc>
#include <ept/cache/debtags/tagmap.tcc>

// vim:set ts=4 sw=4:

