// -*- mode: c++; tab-width: 4; indent-tabs-mode: t -*-
#ifndef EPT_CACHE_DEBTAGS_PKGIDX_H
#define EPT_CACHE_DEBTAGS_PKGIDX_H

/** @file
 * @author Enrico Zini <enrico@enricozini.org>
 * Quick map from package IDs to package names
 */

/*
 * Copyright (C) 2003-2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <ept/forward.h>
#include <ept/path.h>
#include <ept/cache/debtags/update.h>
#include <tagcoll/diskindex/mmap.h>

#include <string>
#include <vector>
#include <map>

namespace ept {
namespace t {
namespace cache {
namespace debtags {

template<typename C>
class PkgIdx : public tagcoll::diskindex::MMap
{
	typedef typename C::Aggregator Aggregator;
	typedef typename C::Index Index;

	tagcoll::diskindex::MasterMMap mastermmap;
	time_t m_timestamp;

public:
	PkgIdx(Aggregator& p);

	time_t timestamp() const { return m_timestamp; }

	/// Get the number of packages in the index
	size_t size() const { return *(int*)m_buf / sizeof(int); }

	const char* name(int id) const
	{
		if (id >= 0 || static_cast<unsigned>(id) < size())
			return m_buf + ((int*)m_buf)[id];
		return NULL;
	}
	int size(int id) const
	{
		if (id < 0 || (unsigned)id >= size())
			return 0;
		if ((unsigned)id == size() - 1)
			return m_size - ((int*)m_buf)[id] - 1;
		else
			return ((int*)m_buf)[id + 1] - ((int*)m_buf)[id] - 1;
	}

	static std::string componentName();
};

template<typename C>
std::string PkgIdx<C>::componentName() { return "PkgIdx"; }

template<typename C>
PkgIdx<C>::PkgIdx(Aggregator& p)
{
	std::string idxfname;

	IndexManager<>::obtainWorkingPkgidx<C>(p, idxfname);

	m_timestamp = Path::timestamp(idxfname);

	mastermmap.init(idxfname);
	tagcoll::diskindex::MMap::init(mastermmap, 0);
}

}
}
}
}

// vim:set ts=4 sw=4:
#endif
