/* 
 * $Id: ctkcontainer.h,v 1.6 2000/07/13 01:02:49 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __CTKCONTAINER_H__
#define __CTKCONTAINER_H__

/* Container Object */

struct CtkContainer_S
{
	CtkWidget widget;
	GNode*    last; /* Ptr to last child */
	
	gint border_width;
	
	void (*set_child_flags)(struct CtkContainer_S* container, 
				CtkWidget* widget);
	void (*lost_child)(struct CtkContainer_S* container,
				CtkWidget* widget);
};

typedef struct CtkContainer_S CtkContainer;

void ctk_container_add(CtkContainer *container, CtkWidget *widget);
void ctk_container_remove(CtkContainer *container, CtkWidget *widget);
void ctk_container_init(CtkContainer *container);
void ctk_container_set_border_width(CtkContainer *container, gint border_width);
#define CTK_CONTAINER(obj)	CTK_CHECK_CAST((obj),CtkContainer,CtkTypeContainer)

void ctk_container_set_default_child_flags(CtkContainer* container, CtkWidget* widget);

#endif
