#include <ctk/ctk.h>
#include <stdio.h>

void toggled(CtkWidget* button, gpointer data)
{
	ctk_noise("Shutdown");
}
void clicked(CtkWidget* button, gpointer data)
{
	ctk_noise("Doink");
}
void enter(CtkWidget* button, gpointer data)
{
	ctk_noise("drip");
}
void leave(CtkWidget* button, gpointer data)
{
	ctk_noise("FingerSnap");
}
void pressed(CtkWidget* button, gpointer data)
{
	ctk_noise("Wooeep");
}
void released(CtkWidget* button, gpointer data)
{
	ctk_noise("Eeeooop");
}

int main(int argc, char** argv)
{
	CtkWidget* window;
	CtkWidget* table;
	CtkWidget* buttons[7];
	CtkWidget* hbox;
	CtkWidget* label;
	
	ctk_init(CTK_USEMOUSE);
	
	/* Window */
	window = ctk_window_new(CTK_WINDOW_TOPLEVEL);
	ctk_widget_set_usize(window,1,1);
	ctk_widget_set_uposition(window,40,12);
   	ctk_window_set_title(CTK_WINDOW(window),"Crazy widget layot");
	ctk_widget_show(window);
	ctk_window_set_autocenter(CTK_WINDOW(window), TRUE);

	/* Table */
	table = ctk_table_new(4,4,FALSE);
	ctk_widget_show(table);
	
	ctk_table_set_col_spacings(CTK_TABLE(table),2);
	ctk_table_set_row_spacings(CTK_TABLE(table),1);
	ctk_container_set_border_width(CTK_CONTAINER(table), 1);
	
	ctk_container_add(CTK_CONTAINER(window),table);
	CTK_WIDGET(table)->xfill = 0;
	CTK_WIDGET(table)->yfill = 0;
	
	buttons[0] = ctk_button_new_with_label("I am 1x2 fY eX fX");
 	ctk_widget_show(buttons[0]);
 	ctk_table_attach(CTK_TABLE(table), buttons[0], 0, 1, 0, 2,
 			CTK_EXPAND|CTK_FILL, CTK_FILL, 0, 0);

	buttons[1] = ctk_button_new();
	label = ctk_button_new_with_label("I am 2x1 fY");
	ctk_widget_show(label);
	hbox = ctk_hbox_new(0, FALSE);
	ctk_widget_show(hbox);
	ctk_box_pack_start(CTK_BOX(hbox), label, FALSE, FALSE, 0);
	ctk_container_add(CTK_CONTAINER(buttons[1]), hbox);
	
 	ctk_widget_show(buttons[1]);
 	ctk_table_attach(CTK_TABLE(table), buttons[1], 0, 2, 2, 3,
 			0, CTK_FILL, 0, 0);

	buttons[2] = ctk_button_new_with_label("I am 4x1 fX eY");
	ctk_container_set_border_width(CTK_CONTAINER(buttons[2]), 1);
 	ctk_widget_show(buttons[2]);
 	ctk_table_attach(CTK_TABLE(table), buttons[2], 0, 4, 3, 4,
 			CTK_FILL, CTK_EXPAND, 0, 0);

	buttons[3] = ctk_button_new_with_label("I am 1x1 fX fY");
 	ctk_widget_show(buttons[3]);
 	ctk_table_attach(CTK_TABLE(table), buttons[3], 1, 2, 0, 1,
 			CTK_FILL, CTK_FILL, 0, 0);

	buttons[4] = ctk_button_new_with_label("I am 2x1 eY ********************");
 	ctk_widget_show(buttons[4]);
 	ctk_table_attach(CTK_TABLE(table), buttons[4], 1, 3, 1, 2,
 			0, CTK_EXPAND, 0, 0);

	buttons[5] = ctk_button_new_with_label("I am 1x1 eX");
 	ctk_widget_show(buttons[5]);
 	ctk_table_attach(CTK_TABLE(table), buttons[5], 2, 3, 2, 3,
 			CTK_EXPAND, 0, 0, 0);

	buttons[6] = ctk_radio_button_new_with_label(NULL, ""); //I am 1x3");
 	ctk_widget_show(buttons[6]);
 	ctk_table_attach(CTK_TABLE(table), buttons[6], 3, 4, 0, 3,
 			0, 0, 0, 0);
 	
 	ctk_table_colour_row(CTK_TABLE(table), 1, table->selected_col);

	ctk_signal_connect(CTK_OBJECT(buttons[6]), "clicked",
						CTK_SIGNAL_FUNC(&clicked), NULL);
	ctk_signal_connect(CTK_OBJECT(buttons[6]), "enter",
						CTK_SIGNAL_FUNC(&enter), NULL);
	ctk_signal_connect(CTK_OBJECT(buttons[6]), "leave",
						CTK_SIGNAL_FUNC(&leave), NULL);
	ctk_signal_connect(CTK_OBJECT(buttons[6]), "pressed",
						CTK_SIGNAL_FUNC(&pressed), NULL);
	ctk_signal_connect(CTK_OBJECT(buttons[6]), "released",
						CTK_SIGNAL_FUNC(&released), NULL);
	ctk_signal_connect(CTK_OBJECT(buttons[6]), "toggled",
						CTK_SIGNAL_FUNC(&toggled), NULL);
	ctk_main();
	return 0;
}
