#if   !defined(__BANKACCOUNT_HPP)
#define  _BANKACCOUNT_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__ABSTRACTBANKACCOUNT_HPP)
#include <AbstractBankAccount.hpp>
#endif

DECLARE_CLASS( BankAccount );

/**
BankAccount is a concrete derivation that implements the
AbstractBankAccount interface. It maintains a available
funds balance and enforces the semantic that you can
no carry a negative balance.
*/

class BankAccount : public AbstractBankAccount
{
public:

   //
   // Constructors and destructor
   //

                        /// Default constructor

                        BankAccount( void );

                        /// Starting balance constructor

                        BankAccount( AmountCref )
                           throw( InvalidAmountException );

                        /// Copy constructor

                        BankAccount( BankAccountCref );

                        /// Virtual destructor

   virtual              ~BankAccount( void );

   //
   // Operator overloads
   //
   
            /**
            Assignment operator
            @param BankAccount const reference
            @return BankAccount reference
            */

            BankAccountRef operator=( BankAccountCref );

            /**
            Equality operator
            @param BankAccount const reference
            @return true if accounts are the same
            */

            bool  operator==( BankAccountCref ) const;
   
   //
   // Accessors
   //
            /**
            Retrieve the account balance
            @return Amount const reference to balance
            */
   
   virtual  AmountCref getBalance(void) const;

   //
   // Mutators
   //
            /**
            Withdraw an amount of funds from the account
            @param Amount - amount to withdraw
            @exception InsufficientFundsException if the
            amount requested to withdraw is not available
            in the account funds
            */
   
   virtual  void withdrawFunds(Amount) 
                     throw(InsufficientFundsException);

            /**
            Deposit funds into the account
            @param Amount - to deposit
            */
   
   virtual  void depositFunds(Amount) 
                     throw(InsufficientFundsException);

private:

            ///   The account available funds

            Amount   theAvailableFunds;
};

#endif

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/02/10 14:32:20 $
   $Locker:  $
*/

