------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                         Copyright (C) 2000-2001                          --
--                                ACT-Europe                                --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
------------------------------------------------------------------------------

package Runme_Info is

   Service_Name : constant String := "AWS-Runme";
   Display_Name : constant String := "AWS Runme Web Demo";
   Client_Name  : constant String := "runme_server.exe";

   function Get_Client_Name_Full_Pathname return String;
   --  Returns Client_Name full pathname. This looks for Client_Name into the
   --  path and if found returns the full pathname to it.

   function Get_Executable_Path return String;
   --  Returns full pathname for Client_Name executable. It uses the
   --  information given by Ada.Command_Line.Command_Name.

end Runme_Info;
