------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                            Copyright (C) 2003                            --
--                               ACT-Europe                                 --
--                                                                          --
--  Authors: Dmitriy Anisimkov - Pascal Obry                                --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
--  As a special exception, if other files instantiate generics from this   --
--  unit, or you link this unit with other files to produce an executable,  --
--  this  unit  does not  by itself cause  the resulting executable to be   --
--  covered by the GNU General Public License. This exception does not      --
--  however invalidate any other reasons why the executable file  might be  --
--  covered by the  GNU Public License.                                     --
------------------------------------------------------------------------------

--  $Id: sock1.adb,v 1.2 2003/12/02 11:47:23 anisimko Exp $

with Ada.Exceptions;
with Ada.Text_IO;
with AWS.Net.Std;

procedure Sock1 is

   use Ada;
   use AWS;

   Sock : Net.Std.Socket_Type
     := Net.Std.Socket_Type (Net.Socket_Type'Class'(Net.Socket (False)));

begin
   Net.Std.Bind (Sock, 1111, "hostname");
exception
   when Net.Socket_Error =>
      Text_IO.Put_Line ("OK : Socket_Error");
   when E : others =>
      Text_IO.Put_Line ("NOK : " & Exceptions.Exception_Name (E));
end Sock1;
